import { f as r } from "./filterMixin-d-cNz5s1.js";
import { l as o } from "./require-Dl4qyrU9.js";
import { createElementBlock as n, createCommentVNode as u, openBlock as f, createElementVNode as i, toDisplayString as l } from "vue";
import { _ as c } from "./main-CkFK4rnR.js";
const p = {
  name: "filter-boolean",
  // Add the filterMixin to get access to all the filters methods and computed properties inside this component
  mixins: [r],
  inject: ["jQuery"],
  data() {
    return {
      isReady: !1
    };
  },
  computed: {
    // Current value of the filter entry.
    value() {
      return this.filterEntry.value;
    },
    trueValue() {
      return Object.prototype.hasOwnProperty.call(this.config, "trueValue") ? this.config.trueValue : "true";
    },
    falseValue() {
      return Object.prototype.hasOwnProperty.call(this.config, "falseValue") ? this.config.falseValue : "false";
    },
    // Settings used when creating the selectize widget.
    selectizeSettings() {
      return {
        // Allow free text because we want to support the contains and startsWith operators.
        create: !1,
        // Take the list of (initial) options from the filter configuration. This list will be extended with the results
        // obtained from the configured search URL.
        options: this.config.options || [],
        // Limit the selection to a single value because:
        // * selecting multiple values increases the height of the filter row when table layout is used
        // * constraint (filter) values should be strings; this isn't a limitation of the live data model, but using
        //   arrays or complex objects make it difficult to express the filter in the REST URL used to fetch the live
        //   data or in the live data macro parameters
        // * the user can still add more values by adding more constraints from the advanced filtering panel
        maxItems: 1,
        onChange: (t) => {
          this.$refs.input.selectize.items.length === 0 ? this.removeFilter() : t !== this.value && this.applyFilter(t);
        }
      };
    }
  },
  watch: {
    value(e) {
      this.jQuery(this.$refs.input).val(e).trigger("change");
    }
  },
  // Create the selectize widget.
  async mounted() {
    await this.logic.translationsLoaded(), this.isReady = !0, await this.$nextTick(), await o("xwiki-selectize"), this.jQuery(this.$refs.input).xwikiSelectize(this.selectizeSettings);
  },
  // Destroy the selectize widget.
  beforeDestroyed() {
    this.$refs.input.selectize?.destroy();
  }
}, d = { key: 0 }, h = ["value", "aria-label"], m = ["value"], y = ["value"];
function v(e, t, g, b, s, a) {
  return s.isReady ? (f(), n("span", d, [
    i("select", {
      value: e.filterEntry.value,
      class: "xwiki-selectize livedata-selectize filter-boolean livedata-filter",
      ref: "input",
      "aria-label": e.$t("livedata.filter.boolean.label")
    }, [
      t[0] || (t[0] = i("option", { value: "" }, null, -1)),
      i("option", { value: a.trueValue }, l(e.$t("livedata.displayer.boolean.true")), 9, m),
      i("option", { value: a.falseValue }, l(e.$t("livedata.displayer.boolean.false")), 9, y)
    ], 8, h)
  ])) : u("", !0);
}
const z = /* @__PURE__ */ c(p, [["render", v]]);
export {
  z as default
};
//# sourceMappingURL=FilterBoolean-C1mm_RUa.js.map
