/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.rest.model.jaxb;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.HashMap;
import java.util.Map;
import javax.xml.bind.annotation.adapters.XmlJavaTypeAdapter;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xwiki.rest.model.jaxb.MapAdapter;

@XmlJavaTypeAdapter(value=MapAdapter.class)
public class StringMap
extends HashMap<String, Object> {
    private static final long serialVersionUID = 1L;
    private static Logger LOGGER = LoggerFactory.getLogger(StringMap.class);

    public static StringMap fromString(String json) {
        try {
            return (StringMap)new ObjectMapper().readerFor(StringMap.class).readValue(json);
        }
        catch (JsonProcessingException e) {
            LOGGER.warn("Failed to convert [{}] to StringMap. Root cause is: [{}].", (Object)json, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return null;
        }
    }

    public static StringMap fromMap(Map<?, ?> map) {
        StringMap stringMap = new StringMap();
        for (Map.Entry<?, ?> entry : map.entrySet()) {
            String key = entry.getKey() != null ? entry.getKey().toString() : null;
            stringMap.put(key, entry.getValue());
        }
        return stringMap;
    }

    @Override
    public String toString() {
        try {
            return new ObjectMapper().writerFor(StringMap.class).writeValueAsString((Object)this);
        }
        catch (JsonProcessingException e) {
            String result = super.toString();
            LOGGER.warn("Failed to serialize StringMap [{}] as JSON. Root cause is: [{}].", (Object)result, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return result;
        }
    }
}

