/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.rest;

import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.internal.rest.AbstractLiveDataResource;
import org.xwiki.livedata.rest.LiveDataPropertyTypesResource;
import org.xwiki.livedata.rest.LiveDataSourceResource;
import org.xwiki.livedata.rest.model.jaxb.PropertyDescriptor;
import org.xwiki.livedata.rest.model.jaxb.Types;
import org.xwiki.rest.model.jaxb.Link;

@Component
@Named(value="org.xwiki.livedata.internal.rest.DefaultLiveDataPropertyTypesResource")
public class DefaultLiveDataPropertyTypesResource
extends AbstractLiveDataResource
implements LiveDataPropertyTypesResource {
    @Override
    public Types getTypes(String sourceId, String namespace) throws Exception {
        LiveDataConfiguration config = this.getLiveDataConfig(sourceId);
        Optional source = this.liveDataSourceManager.get(config.getQuery().getSource(), namespace);
        if (source.isPresent()) {
            return this.createPropertyTypes(config.getMeta().getPropertyTypes(), config.getQuery().getSource(), namespace);
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private Types createPropertyTypes(Collection<LiveDataPropertyDescriptor> propertyTypes, LiveDataQuery.Source source, String namespace) {
        Link self = new Link().withRel("self").withHref(this.uriInfo.getAbsolutePath().toString());
        Link parent = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/parent", LiveDataSourceResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        List<PropertyDescriptor> types = propertyTypes.stream().map(propertyType -> this.createPropertyType((LiveDataPropertyDescriptor)propertyType, source, namespace)).collect(Collectors.toList());
        return (Types)new Types().withTypes(types).withLinks(new Link[]{self, parent});
    }
}

