/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.rest;

import java.util.Optional;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSource;
import org.xwiki.livedata.internal.rest.AbstractLiveDataResource;
import org.xwiki.livedata.rest.LiveDataPropertyResource;
import org.xwiki.livedata.rest.model.jaxb.PropertyDescriptor;

@Component
@Named(value="org.xwiki.livedata.internal.rest.DefaultLiveDataPropertyResource")
public class DefaultLiveDataPropertyResource
extends AbstractLiveDataResource
implements LiveDataPropertyResource {
    @Override
    public PropertyDescriptor getProperty(String sourceId, String namespace, String propertyId) throws Exception {
        Optional property;
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent() && (property = ((LiveDataSource)source.get()).getProperties().get(propertyId)).isPresent()) {
            return this.createProperty((LiveDataPropertyDescriptor)property.get(), querySource, namespace);
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @Override
    public Response updateProperty(String sourceId, String namespace, String propertyId, PropertyDescriptor propertyDescriptor) throws Exception {
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent()) {
            Optional property;
            propertyDescriptor.setId(propertyId);
            if (((LiveDataSource)source.get()).getProperties().save(this.convert(propertyDescriptor)) && (property = ((LiveDataSource)source.get()).getProperties().get(propertyId)).isPresent()) {
                PropertyDescriptor updatedProperty = this.createProperty((LiveDataPropertyDescriptor)property.get(), querySource, namespace);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity((Object)updatedProperty).build();
            }
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @Override
    public void deleteProperty(String sourceId, String namespace, String propertyId) throws Exception {
        Optional removedProperty;
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent() && (removedProperty = ((LiveDataSource)source.get()).getProperties().remove(propertyId)).isPresent()) {
            return;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }
}

