/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.rest;

import java.util.Optional;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSource;
import org.xwiki.livedata.internal.rest.AbstractLiveDataResource;
import org.xwiki.livedata.rest.LiveDataEntryPropertyResource;

@Component
@Named(value="org.xwiki.livedata.internal.rest.DefaultLiveDataEntryPropertyResource")
public class DefaultLiveDataEntryPropertyResource
extends AbstractLiveDataResource
implements LiveDataEntryPropertyResource {
    @Override
    public Object getProperty(String sourceId, String namespace, String entryId, String propertyId) throws Exception {
        Optional value;
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent() && (value = ((LiveDataSource)source.get()).getEntries().get((Object)entryId, propertyId)).isPresent()) {
            return value.get();
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    @Override
    public Response setProperty(String sourceId, String namespace, String entryId, String propertyId, String value) {
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent()) {
            try {
                LiveDataSource liveDataSource = (LiveDataSource)source.get();
                if (!liveDataSource.getProperties().get(propertyId).map(LiveDataPropertyDescriptor::isEditable).orElse(false).booleanValue()) {
                    return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
                }
                liveDataSource.getEntries().update((Object)entryId, propertyId, (Object)value);
                Object newValue = liveDataSource.getEntries().get((Object)entryId, propertyId).orElse(null);
                return Response.status((Response.Status)Response.Status.ACCEPTED).entity(newValue).build();
            }
            catch (LiveDataException e) {
                return Response.status((Response.Status)Response.Status.BAD_REQUEST).build();
            }
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }
}

