/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.rest;

import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.ws.rs.WebApplicationException;
import javax.ws.rs.core.Response;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveData;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataEntryStore;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSource;
import org.xwiki.livedata.internal.rest.AbstractLiveDataResource;
import org.xwiki.livedata.internal.rest.LiveDataResourceContextInitializer;
import org.xwiki.livedata.rest.LiveDataEntriesResource;
import org.xwiki.livedata.rest.LiveDataEntryResource;
import org.xwiki.livedata.rest.LiveDataSourceResource;
import org.xwiki.livedata.rest.model.jaxb.Entries;
import org.xwiki.livedata.rest.model.jaxb.Entry;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;

@Component
@Named(value="org.xwiki.livedata.internal.rest.DefaultLiveDataEntriesResource")
public class DefaultLiveDataEntriesResource
extends AbstractLiveDataResource
implements LiveDataEntriesResource {
    private static final String FILTERS_PREFIX = "filters.";
    @Inject
    private LiveDataResourceContextInitializer contextInitializer;

    @Override
    public Entries getEntries(String sourceId, String namespace, List<String> properties, List<String> matchAll, List<String> sort, List<Boolean> descending, long offset, int limit) throws Exception {
        this.contextInitializer.initialize(namespace);
        int validatedLimit = this.validateAndGetLimit(limit);
        LiveDataConfiguration config = this.initConfig(sourceId, properties, matchAll, sort, descending, offset, validatedLimit);
        return this.getEntries(namespace, offset, validatedLimit, config);
    }

    @Override
    public Response addEntry(String sourceId, String namespace, Entry entry) throws Exception {
        LiveDataQuery.Source querySource = this.getLiveDataQuerySource(sourceId);
        Optional source = this.liveDataSourceManager.get(querySource, namespace);
        if (source.isPresent()) {
            Optional values;
            LiveDataEntryStore entryStore = ((LiveDataSource)source.get()).getEntries();
            Optional entryId = entryStore.save((Map)entry.getValues());
            if (entryId.isPresent() && (values = entryStore.get(entryId.get())).isPresent()) {
                Entry addedEntry = this.createEntry((Map)values.get(), entryId.get(), querySource, namespace);
                URI location = Utils.createURI((URI)this.uriInfo.getBaseUri(), LiveDataEntryResource.class, (Object[])new Object[]{sourceId, entryId.get()});
                location = this.withNamespaceAndSourceParams(location, namespace, (Map<String, Object>)querySource.getParameters());
                return Response.created((URI)location).entity((Object)addedEntry).build();
            }
            return null;
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }

    private LiveDataConfiguration getConfig(String sourceId, List<String> properties, List<String> matchAll, List<String> sort, List<Boolean> descending, long offset, int limit) throws LiveDataException {
        LiveDataQuery query = new LiveDataQuery();
        query.setSource(this.getLiveDataQuerySource(sourceId));
        query.setProperties(properties.stream().filter(StringUtils::isNotEmpty).collect(Collectors.toList()));
        query.setFilters(this.getFilters(matchAll));
        query.setSort(this.getSort(sort, descending));
        query.setOffset(Long.valueOf(offset));
        query.setLimit(Integer.valueOf(limit));
        LiveDataConfiguration config = new LiveDataConfiguration();
        config.setQuery(query);
        return this.defaultLiveDataConfigResolver.resolve((Object)config);
    }

    private List<LiveDataQuery.SortEntry> getSort(List<String> sortList, List<Boolean> descendingList) {
        ArrayList<LiveDataQuery.SortEntry> sortEntries = new ArrayList<LiveDataQuery.SortEntry>();
        for (int i = 0; i < sortList.size(); ++i) {
            String property = sortList.get(i);
            boolean descending = i < descendingList.size() ? descendingList.get(i) : false;
            sortEntries.add(new LiveDataQuery.SortEntry(property, descending));
        }
        return sortEntries;
    }

    private List<LiveDataQuery.Filter> getFilters(List<String> matchAll) {
        ArrayList<LiveDataQuery.Filter> filters = new ArrayList<LiveDataQuery.Filter>();
        this.uriInfo.getQueryParameters().forEach((key, values) -> {
            String property;
            LiveDataQuery.Filter filter;
            if (key.startsWith(FILTERS_PREFIX) && !(filter = this.getFilter(property = key.substring(FILTERS_PREFIX.length()), matchAll.contains(property), (List<String>)values)).getConstraints().isEmpty()) {
                filters.add(filter);
            }
        });
        return filters;
    }

    private LiveDataQuery.Filter getFilter(String property, boolean matchAll, List<String> constraints) {
        LiveDataQuery.Filter filter = new LiveDataQuery.Filter();
        filter.setProperty(property);
        filter.setMatchAll(matchAll);
        String operatorSeparator = ":";
        for (String constraint : constraints) {
            if (!constraint.contains(operatorSeparator)) continue;
            String[] parts = constraint.split(operatorSeparator, 2);
            String value = parts[1];
            String operator = StringUtils.isBlank((CharSequence)parts[0]) ? null : parts[0];
            filter.getConstraints().add(new LiveDataQuery.Constraint((Object)value, operator));
        }
        return filter;
    }

    private Entries createEntries(LiveData liveData, String idProperty, LiveDataQuery.Source source, String namespace) {
        Link self = new Link().withRel("self").withHref(this.uriInfo.getAbsolutePath().toString());
        Link parent = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/parent", LiveDataSourceResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        List<Entry> entries = liveData.getEntries().stream().map(values -> this.createEntry((Map<String, Object>)values, values.get(idProperty), source, namespace)).collect(Collectors.toList());
        return (Entries)new Entries().withEntries(entries).withCount(liveData.getCount()).withLinks(new Link[]{self, parent});
    }

    private LiveDataConfiguration initConfig(String sourceId, List<String> properties, List<String> matchAll, List<String> sort, List<Boolean> descending, long offset, int limit) throws LiveDataException {
        List<String> actualProperties = properties.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<String> actualMatchAll = matchAll.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<String> actualSort = sort.stream().filter(Objects::nonNull).collect(Collectors.toList());
        List<Boolean> actualDescending = descending.stream().filter(Objects::nonNull).collect(Collectors.toList());
        return this.getConfig(sourceId, actualProperties, actualMatchAll, actualSort, actualDescending, offset, limit);
    }

    private Entries getEntries(String namespace, long offset, int limit, LiveDataConfiguration config) throws LiveDataException {
        Optional source = this.liveDataSourceManager.get(config.getQuery().getSource(), namespace);
        if (source.isPresent()) {
            String idProperty = config.getMeta().getEntryDescriptor().getIdProperty();
            LiveDataEntryStore entryStore = ((LiveDataSource)source.get()).getEntries();
            return this.createEntries(entryStore.get(config.getQuery()), idProperty, config.getQuery().getSource(), namespace).withOffset(offset).withLimit(limit);
        }
        throw new WebApplicationException(Response.Status.NOT_FOUND);
    }
}

