/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.rest;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.ws.rs.core.UriBuilder;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSourceManager;
import org.xwiki.livedata.rest.LiveDataEntriesResource;
import org.xwiki.livedata.rest.LiveDataEntryResource;
import org.xwiki.livedata.rest.LiveDataPropertiesResource;
import org.xwiki.livedata.rest.LiveDataPropertyResource;
import org.xwiki.livedata.rest.LiveDataPropertyTypeResource;
import org.xwiki.livedata.rest.LiveDataPropertyTypesResource;
import org.xwiki.livedata.rest.LiveDataSourceResource;
import org.xwiki.livedata.rest.LiveDataSourcesResource;
import org.xwiki.livedata.rest.model.jaxb.Entry;
import org.xwiki.livedata.rest.model.jaxb.PropertyDescriptor;
import org.xwiki.livedata.rest.model.jaxb.Source;
import org.xwiki.livedata.rest.model.jaxb.StringMap;
import org.xwiki.rest.XWikiResource;
import org.xwiki.rest.internal.Utils;
import org.xwiki.rest.model.jaxb.Link;

public abstract class AbstractLiveDataResource
extends XWikiResource {
    private static final String SOURCE_PARAMS_PREFIX = "sourceParams.";
    @Inject
    protected LiveDataSourceManager liveDataSourceManager;
    @Inject
    protected LiveDataConfigurationResolver<LiveDataConfiguration> defaultLiveDataConfigResolver;

    protected LiveDataConfiguration getLiveDataConfig(String sourceId) throws LiveDataException {
        LiveDataConfiguration config = new LiveDataConfiguration();
        config.setQuery(new LiveDataQuery());
        config.getQuery().setSource(this.getLiveDataQuerySource(sourceId));
        return this.defaultLiveDataConfigResolver.resolve((Object)config);
    }

    protected LiveDataQuery.Source getLiveDataQuerySource(String sourceId) {
        LiveDataQuery.Source source = new LiveDataQuery.Source(sourceId);
        source.getParameters().putAll(this.getLiveDataSourceParameters());
        return source;
    }

    protected Map<String, Object> getLiveDataSourceParameters() {
        HashMap<String, Object> params = new HashMap<String, Object>();
        this.uriInfo.getQueryParameters().forEach((key, values) -> {
            if (key.startsWith(SOURCE_PARAMS_PREFIX)) {
                List value = values.size() == 1 ? values.get(0) : values;
                params.put(key.substring(SOURCE_PARAMS_PREFIX.length()), value);
            }
        });
        return params;
    }

    protected Link createLink(String relation, Class<?> resourceClass, Object ... pathElements) {
        String href = Utils.createURI((URI)this.uriInfo.getBaseUri(), resourceClass, (Object[])pathElements).toString();
        return new Link().withRel(relation).withHref(href);
    }

    protected Source createSource(LiveDataQuery.Source source, String namespace) {
        Link self = this.withNamespaceAndSourceParams(this.createLink("self", LiveDataSourceResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        Link parent = this.withNamespace(this.createLink("http://www.xwiki.org/rel/parent", LiveDataSourcesResource.class, new Object[0]), namespace);
        Link entries = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/entries", LiveDataEntriesResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        Link properties = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/properties", LiveDataPropertiesResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        Link propertyTypes = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/propertyTypes", LiveDataPropertyTypesResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        return (Source)new Source().withHint(source.getId()).withLinks(new Link[]{self, parent, entries, properties, propertyTypes});
    }

    protected Link withNamespace(Link link, String namespace) {
        return this.withNamespaceAndSourceParams(link, namespace, Collections.emptyMap());
    }

    protected Link withNamespaceAndSourceParams(Link link, String namespace, Map<String, Object> sourceParams) {
        try {
            link.setHref(this.withNamespaceAndSourceParams(new URI(link.getHref()), namespace, sourceParams).toString());
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return link;
    }

    protected URI withNamespaceAndSourceParams(URI uri, String namespace, Map<String, Object> sourceParams) {
        UriBuilder uriBuilder = UriBuilder.fromUri((URI)uri);
        if (!StringUtils.isEmpty((CharSequence)namespace)) {
            uriBuilder.queryParam("namespace", new Object[]{namespace});
        }
        sourceParams.entrySet().forEach(entry -> {
            List values = entry.getValue() instanceof Iterable ? (List)entry.getValue() : Collections.singletonList(entry.getValue());
            values.forEach(value -> uriBuilder.queryParam(SOURCE_PARAMS_PREFIX + (String)entry.getKey(), new Object[]{value}));
        });
        return uriBuilder.build(new Object[0]);
    }

    protected PropertyDescriptor createPropertyDescriptor(LiveDataPropertyDescriptor descriptor) {
        descriptor.initialize();
        StringMap icon = new StringMap();
        icon.putAll(descriptor.getIcon());
        return new PropertyDescriptor().withId(descriptor.getId()).withName(descriptor.getName()).withDescription(descriptor.getDescription()).withIcon(icon).withVisible(descriptor.isVisible()).withDisplayer(descriptor.getDisplayer()).withSortable(descriptor.isSortable()).withFilterable(descriptor.isFilterable()).withFilter(descriptor.getFilter()).withType(descriptor.getType()).withStyleName(descriptor.getStyleName());
    }

    protected PropertyDescriptor createProperty(LiveDataPropertyDescriptor descriptor, LiveDataQuery.Source source, String namespace) {
        PropertyDescriptor property = this.createPropertyDescriptor(descriptor);
        Link self = this.withNamespaceAndSourceParams(this.createLink("self", LiveDataPropertyResource.class, source.getId(), property.getId()), namespace, (Map<String, Object>)source.getParameters());
        property.getLinks().add(self);
        Link parent = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/parent", LiveDataPropertiesResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        property.getLinks().add(parent);
        return property;
    }

    protected PropertyDescriptor createPropertyType(LiveDataPropertyDescriptor descriptor, LiveDataQuery.Source source, String namespace) {
        PropertyDescriptor propertyType = this.createPropertyDescriptor(descriptor);
        Link self = this.withNamespaceAndSourceParams(this.createLink("self", LiveDataPropertyTypeResource.class, source.getId(), propertyType.getId()), namespace, (Map<String, Object>)source.getParameters());
        propertyType.getLinks().add(self);
        Link parent = this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/parent", LiveDataPropertyTypesResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters());
        propertyType.getLinks().add(parent);
        return propertyType;
    }

    protected Entry createEntry(Map<String, Object> values, Object entryId, LiveDataQuery.Source source, String namespace) {
        ArrayList<Link> links = new ArrayList<Link>();
        if (entryId != null) {
            links.add(this.withNamespaceAndSourceParams(this.createLink("self", LiveDataEntryResource.class, source.getId(), entryId), namespace, (Map<String, Object>)source.getParameters()));
        }
        links.add(this.withNamespaceAndSourceParams(this.createLink("http://www.xwiki.org/rel/parent", LiveDataEntriesResource.class, source.getId()), namespace, (Map<String, Object>)source.getParameters()));
        return (Entry)new Entry().withValues(StringMap.fromMap(values)).withLinks(links);
    }

    protected LiveDataPropertyDescriptor convert(PropertyDescriptor descriptor) {
        LiveDataPropertyDescriptor propertyDescriptor = new LiveDataPropertyDescriptor();
        propertyDescriptor.setId(descriptor.getId());
        propertyDescriptor.setName(descriptor.getName());
        propertyDescriptor.setDescription(descriptor.getDescription());
        propertyDescriptor.getIcon().putAll(descriptor.getIcon());
        propertyDescriptor.setType(descriptor.getType());
        propertyDescriptor.setVisible(Boolean.valueOf(descriptor.isVisible()));
        propertyDescriptor.setSortable(Boolean.valueOf(descriptor.isSortable()));
        propertyDescriptor.setFilterable(Boolean.valueOf(descriptor.isFilterable()));
        propertyDescriptor.setDisplayer(descriptor.getDisplayer());
        propertyDescriptor.setFilter(descriptor.getFilter());
        propertyDescriptor.setStyleName(descriptor.getStyleName());
        return propertyDescriptor;
    }
}

