/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.script.livetable;

import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.livetable.LiveTableConfiguration;
import org.xwiki.script.service.ScriptService;

@Component
@Named(value="liveData.liveTable")
@Singleton
public class LiveTableScriptService
implements ScriptService {
    @Inject
    private Logger logger;
    @Inject
    @Named(value="liveTable")
    private LiveDataConfigurationResolver<LiveTableConfiguration> liveTableLiveDataConfigResolver;
    @Inject
    private LiveDataConfigurationResolver<LiveDataConfiguration> defaultLiveDataConfigurationResolver;

    public LiveDataConfiguration getConfig(String id, List<String> columns, Map<String, Object> columnProperties, Map<String, Object> options) {
        try {
            LiveTableConfiguration liveTableConfig = new LiveTableConfiguration(id, columns, columnProperties, options);
            LiveDataConfiguration liveDataConfig = this.liveTableLiveDataConfigResolver.resolve((Object)liveTableConfig);
            return this.defaultLiveDataConfigurationResolver.resolve((Object)liveDataConfig);
        }
        catch (LiveDataException e) {
            this.logger.warn("Failed to get live data config for id [{}], columns [{}], columnProperties [{}] and options [{}]. Root cause is [{}].", new Object[]{id, columns, columnProperties, options, ExceptionUtils.getRootCauseMessage((Throwable)e)});
            return null;
        }
    }
}

