/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.livetable;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import com.xpn.xwiki.objects.BaseCollection;
import com.xpn.xwiki.objects.BaseObject;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.IntStream;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.security.authorization.AccessDeniedException;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.wysiwyg.converter.HTMLConverter;

@Component(roles={ModelBridge.class})
@Singleton
public class ModelBridge {
    private static final String NEW_DOCUMENT_UPDATE_ERROR = "We do not support updating new documents.";
    private static final String REQUIRES_HTML_CONVERSION = "RequiresHTMLConversion";
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private HTMLConverter htmlConverter;
    @Inject
    @Named(value="local")
    private EntityReferenceSerializer<String> localSerializer;
    @Inject
    private Logger logger;

    public Optional<Object> update(String property, Object value, DocumentReference documentReference, DocumentReference classReference) throws AccessDeniedException, XWikiException, LiveDataException {
        return this.update(property, value, documentReference, classReference, 0);
    }

    public Optional<Object> update(String property, Object value, DocumentReference documentReference, DocumentReference classReference, int objectNumber) throws AccessDeniedException, XWikiException, LiveDataException {
        this.authorization.checkAccess(Right.EDIT, (EntityReference)documentReference);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        if (document.isNew()) {
            throw new LiveDataException(NEW_DOCUMENT_UPDATE_ERROR);
        }
        document = document.clone();
        Object changedValue = this.updateProperty(property, value, classReference, objectNumber, document);
        this.saveDocument(document);
        return Optional.ofNullable(changedValue);
    }

    public void updateAll(Map<String, Object> properties, DocumentReference documentReference, DocumentReference classReference) throws AccessDeniedException, XWikiException, LiveDataException {
        this.updateAll(properties, documentReference, classReference, 0);
    }

    public void updateAll(Map<String, Object> properties, DocumentReference documentReference, DocumentReference classReference, int objectNumber) throws AccessDeniedException, XWikiException, LiveDataException {
        this.authorization.checkAccess(Right.EDIT, (EntityReference)documentReference);
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWikiDocument document = xcontext.getWiki().getDocument(documentReference, xcontext);
        if (document.isNew()) {
            throw new LiveDataException(NEW_DOCUMENT_UPDATE_ERROR);
        }
        document = document.clone();
        this.convertPropertiesFromHtml(properties, (String)this.localSerializer.serialize((EntityReference)classReference, new Object[0]), objectNumber);
        for (Map.Entry<String, Object> property : properties.entrySet()) {
            this.updateProperty(property.getKey(), property.getValue(), classReference, objectNumber, document);
        }
        this.saveDocument(document);
    }

    private void convertPropertiesFromHtml(Map<String, Object> properties, String className, int objectNumber) {
        if (properties.containsKey(REQUIRES_HTML_CONVERSION)) {
            String requiresHTMLConversion = (String)properties.get(REQUIRES_HTML_CONVERSION);
            properties.remove(REQUIRES_HTML_CONVERSION);
            for (String requiresHTMLConversionProperty : requiresHTMLConversion.split(",")) {
                String propertyName = requiresHTMLConversionProperty.replace(className, "").replaceFirst(String.format("_%d_", objectNumber), "");
                String syntaxKey = propertyName + "_syntax";
                String cacheKey = propertyName + "_cache";
                if (properties.containsKey(propertyName)) {
                    String property = (String)properties.get(propertyName);
                    properties.put(propertyName, this.htmlConverter.fromHTML(property, (String)properties.get(syntaxKey)));
                }
                properties.remove(syntaxKey);
                properties.remove(cacheKey);
            }
        }
    }

    private void saveDocument(XWikiDocument document) throws XWikiException, LiveDataException {
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        if (document.isContentDirty() || document.isMetaDataDirty()) {
            boolean validate = document.validate(xcontext);
            if (!validate) {
                throw new LiveDataException("Document not validated.");
            }
            document.setAuthorReference(xcontext.getUserReference());
            xcontext.getWiki().saveDocument(document, "LiveData update.", true, xcontext);
        }
    }

    private Object updateProperty(String property, Object value, DocumentReference classReference, int objectNumber, XWikiDocument document) throws XWikiException, LiveDataException {
        Object changedValue = ((String)StringUtils.defaultIfEmpty((CharSequence)property, (CharSequence)"")).startsWith("doc.") ? this.updateDocument(property.substring(4), value, document) : this.updateXObject(property, value, document, classReference, objectNumber);
        return changedValue;
    }

    private Object updateXObject(String property, Object value, XWikiDocument document, DocumentReference classReference, int objectNumber) throws XWikiException, LiveDataException {
        String changedValue = null;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        BaseObject baseObject = document.getXObject(classReference, objectNumber);
        if (baseObject == null) {
            throw new LiveDataException(String.format("XObject [%s] not found at index [%d] in [%s]", classReference, objectNumber, document));
        }
        BaseClass xClass = baseObject.getXClass(xcontext);
        List<String> properties = Arrays.asList(baseObject.getPropertyNames());
        if (properties.contains(property)) {
            A[] newValue;
            changedValue = baseObject.get(property).toFormString();
            if (value instanceof List) {
                List list = (List)value;
                newValue = IntStream.range(0, list.size()).mapToObj(i -> String.valueOf(list.get(i))).toArray(String[]::new);
            } else {
                newValue = value;
            }
            xClass.fromMap(Collections.singletonMap(property, newValue), (BaseCollection)baseObject);
        }
        return changedValue;
    }

    private Object updateDocument(String property, Object value, XWikiDocument document) {
        Object changedValue = null;
        if (Objects.equals(property, "hidden")) {
            changedValue = document.isHidden();
            document.setHidden(Boolean.valueOf(String.valueOf(value)));
        } else if (Objects.equals(property, "title")) {
            changedValue = document.getTitle();
            document.setTitle(String.valueOf(value));
        } else if (Objects.equals(property, "content")) {
            changedValue = document.getContent();
            document.setContent((String)value);
        } else if (!Objects.equals(property, "fullName")) {
            this.logger.warn("Unknown property [{}]. Document [{}] will not be updated with value [{}].", new Object[]{property, document, value});
        }
        return changedValue;
    }
}

