/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.livetable;

import com.fasterxml.jackson.core.json.JsonReadFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.json.JsonMapper;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.xpn.xwiki.XWikiException;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.livedata.LiveData;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataEntryStore;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.WithParameters;
import org.xwiki.livedata.internal.livetable.LiveTableLiveDataResultsRenderer;
import org.xwiki.livedata.internal.livetable.ModelBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.security.authorization.AccessDeniedException;

@Component
@Named(value="liveTable")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class LiveTableLiveDataEntryStore
extends WithParameters
implements LiveDataEntryStore {
    public static final String ROLE_HINT = "liveTable";
    private static final String CLASS_NAME_PARAMETER = "className";
    private static final String DOC_PREFIX = "doc.";
    private static final String UNDEFINED_CLASS_ERROR_MESSAGE = "Can't update object properties if the object type (class name) is undefined.";
    @Inject
    private LiveTableLiveDataResultsRenderer resultsRenderer;
    @Inject
    @Named(value="current")
    private DocumentReferenceResolver<String> currentDocumentReferenceResolver;
    @Inject
    private ModelBridge modelBridge;
    @Inject
    @Named(value="liveTable")
    private Provider<LiveDataConfiguration> liveDataConfigurationProvider;

    public Optional<Map<String, Object>> get(Object entryId) {
        throw new UnsupportedOperationException();
    }

    public LiveData get(LiveDataQuery query) throws LiveDataException {
        try {
            ObjectMapper objectMapper = JsonMapper.builder().enable(new JsonReadFeature[]{JsonReadFeature.ALLOW_BACKSLASH_ESCAPING_ANY_CHARACTER}).build();
            JsonNode liveTableResults = this.getLiveTableResultsJSON(query, objectMapper);
            LiveData liveData = new LiveData();
            liveData.setCount(liveTableResults.path("totalrows").asLong());
            JsonNode rows = liveTableResults.path("rows");
            if (rows.isArray()) {
                liveData.getEntries().addAll(this.convertLiveTableRowsToLiveDataEntries((ArrayNode)rows, objectMapper));
            }
            return liveData;
        }
        catch (Exception e) {
            throw new LiveDataException("Failed to execute the live data query.", (Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private JsonNode getLiveTableResultsJSON(LiveDataQuery query, ObjectMapper objectMapper) throws Exception {
        LiveDataQuery.Source originalSource = query.getSource();
        query.setSource(new LiveDataQuery.Source(ROLE_HINT));
        query.getSource().getParameters().putAll(this.getParameters());
        if (originalSource != null) {
            query.getSource().getParameters().putAll(originalSource.getParameters());
        }
        try {
            Object template = query.getSource().getParameters().get("template");
            Object resultPage = query.getSource().getParameters().get("resultPage");
            String liveTableResultsJSON = template instanceof String ? this.resultsRenderer.getLiveTableResultsFromTemplate((String)template, query) : (resultPage instanceof String ? this.resultsRenderer.getLiveTableResultsFromPage((String)resultPage, query) : this.resultsRenderer.getLiveTableResultsFromPage("XWiki.LiveTableResults", query));
            JsonNode jsonNode = objectMapper.readTree(liveTableResultsJSON);
            return jsonNode;
        }
        finally {
            query.setSource(originalSource);
        }
    }

    private List<Map<String, Object>> convertLiveTableRowsToLiveDataEntries(ArrayNode rows, ObjectMapper objectMapper) throws Exception {
        LinkedList<Map<String, Object>> entries = new LinkedList<Map<String, Object>>();
        for (JsonNode row : rows) {
            if (!row.isObject()) continue;
            Map entry = (Map)objectMapper.readerForMapOf(Object.class).readValue(row);
            Set<String> keysToRename = entry.keySet().stream().filter(key -> key.startsWith("doc_")).collect(Collectors.toSet());
            keysToRename.forEach(key -> entry.put(DOC_PREFIX + key.substring(4), entry.remove(key)));
            entries.add(entry);
        }
        return entries;
    }

    public Optional<Object> update(Object entryId, String property, Object value) throws LiveDataException {
        String className = (String)this.getParameters().get(CLASS_NAME_PARAMETER);
        if (className == null && !((String)StringUtils.defaultIfEmpty((CharSequence)property, (CharSequence)"")).startsWith(DOC_PREFIX)) {
            throw new LiveDataException(UNDEFINED_CLASS_ERROR_MESSAGE);
        }
        DocumentReference documentReference = this.currentDocumentReferenceResolver.resolve((Object)((String)entryId), new Object[0]);
        DocumentReference classReference = className != null ? this.currentDocumentReferenceResolver.resolve((Object)className, new Object[0]) : null;
        try {
            return this.modelBridge.update(property, value, documentReference, classReference);
        }
        catch (XWikiException | LiveDataException | AccessDeniedException e) {
            throw new LiveDataException(e);
        }
    }

    public Optional<Object> save(Map<String, Object> entry) throws LiveDataException {
        String className = (String)this.getParameters().get(CLASS_NAME_PARAMETER);
        boolean hasXObjectPropertiesToUpdate = entry.keySet().stream().anyMatch(it -> !((String)StringUtils.defaultIfEmpty((CharSequence)it, (CharSequence)"")).startsWith(DOC_PREFIX));
        if (className == null && hasXObjectPropertiesToUpdate) {
            throw new LiveDataException(UNDEFINED_CLASS_ERROR_MESSAGE);
        }
        String entryId = ((LiveDataConfiguration)this.liveDataConfigurationProvider.get()).getMeta().getEntryDescriptor().getIdProperty();
        String fullName = (String)entry.get(entryId);
        if (fullName == null) {
            throw new LiveDataException(String.format("Entry id [%s] missing. Can't load the document to update.", entryId));
        }
        DocumentReference documentReference = this.currentDocumentReferenceResolver.resolve((Object)fullName, new Object[0]);
        DocumentReference classReference = className != null ? this.currentDocumentReferenceResolver.resolve((Object)className, new Object[0]) : null;
        try {
            this.modelBridge.updateAll(entry, documentReference, classReference);
        }
        catch (XWikiException | AccessDeniedException e) {
            throw new LiveDataException(e);
        }
        return Optional.of(fullName);
    }
}

