/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.livetable;

import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.node.ObjectNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.LiveDataMeta;
import org.xwiki.livedata.LiveDataPaginationConfiguration;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.internal.livetable.LiveTableResultsURLDocumentReferenceResolver;
import org.xwiki.livedata.internal.livetable.PropertyTypeSupplier;
import org.xwiki.livedata.internal.livetable.URLQueryStringParser;
import org.xwiki.livedata.livetable.LiveTableConfiguration;

@Component
@Named(value="liveTable")
@Singleton
public class LiveTableLiveDataConfigurationResolver
implements LiveDataConfigurationResolver<LiveTableConfiguration> {
    private static final String HTML = "html";
    private static final String LINK = "link";
    private static final String ACTIONS = "actions";
    private static final String TYPE = "type";
    private static final String HIDDEN = "hidden";
    private static final String CLASS_NAME = "className";
    private static final String QUERY_FILTERS = "queryFilters";
    private static final Map<String, String> DEFAULT_OPERATOR = new HashMap<String, String>(){
        {
            this.put("exact", "equals");
            this.put("partial", "contains");
            this.put("prefix", "startsWith");
        }
    };
    @Inject
    private Logger logger;
    @Inject
    @Named(value="liveTable")
    private LiveDataConfigurationResolver<LiveDataConfiguration> defaultConfigResolver;
    @Inject
    private PropertyTypeSupplier propertyTypeSupplier;
    @Inject
    private LiveTableResultsURLDocumentReferenceResolver urlDocumentReferenceResolver;
    private final URLQueryStringParser urlQueryStringParser = new URLQueryStringParser();

    public LiveDataConfiguration resolve(LiveTableConfiguration liveTableConfig) throws LiveDataException {
        ObjectMapper objectMapper = new ObjectMapper();
        ObjectNode columnPropertiesJSON = (ObjectNode)objectMapper.valueToTree(liveTableConfig.getColumnProperties());
        ObjectNode optionsJSON = (ObjectNode)objectMapper.valueToTree(liveTableConfig.getOptions());
        LiveDataConfiguration config = this.getConfig(liveTableConfig.getId(), liveTableConfig.getColumns(), columnPropertiesJSON, optionsJSON);
        return this.defaultConfigResolver.resolve((Object)config);
    }

    private LiveDataConfiguration getConfig(String id, List<String> columns, ObjectNode columnProperties, ObjectNode options) {
        LiveDataConfiguration config = new LiveDataConfiguration();
        config.setId(id);
        config.setQuery(this.getQueryConfig(columns, options));
        config.setMeta(this.getMetaConfig(columnProperties, options));
        return config;
    }

    private LiveDataQuery getQueryConfig(List<String> columns, ObjectNode options) {
        LiveDataQuery queryConfig = new LiveDataQuery();
        queryConfig.setProperties(columns);
        queryConfig.setSource(this.getSourceConfig(options));
        this.processExtraParams(options, queryConfig);
        queryConfig.setSort(this.getSortConfig(options));
        JsonNode rowCount = options.path("rowCount");
        if (rowCount.isNumber()) {
            queryConfig.setLimit(Integer.valueOf(rowCount.asInt()));
        }
        return queryConfig;
    }

    private LiveDataQuery.Source getSourceConfig(ObjectNode options) {
        LiveDataQuery.Source source = new LiveDataQuery.Source();
        source.setId("liveTable");
        for (String parameter : Arrays.asList(CLASS_NAME, "resultPage", "translationPrefix")) {
            if (!options.path(parameter).isTextual()) continue;
            source.setParameter(parameter, (Object)options.path(parameter).asText());
        }
        JsonNode queryFilters = options.path(QUERY_FILTERS);
        if (queryFilters.isTextual()) {
            source.setParameter(QUERY_FILTERS, (Object)queryFilters.asText());
        } else if (queryFilters.isArray()) {
            ArrayList values = new ArrayList();
            queryFilters.forEach(queryFilter -> values.add(queryFilter.asText()));
            source.setParameter(QUERY_FILTERS, (Object)StringUtils.join(values, (char)','));
        }
        JsonNode urlNode = options.path("url");
        if (urlNode.isTextual()) {
            String url = urlNode.asText();
            try {
                this.addSourceParametersFromURL(source, url);
            }
            catch (Exception e) {
                this.logger.warn("Failed to extract live data source parameters from live table results URL [{}]. Root cause is [{}].", (Object)url, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
        return source;
    }

    private void addSourceParametersFromURL(LiveDataQuery.Source source, String url) throws Exception {
        Map<String, List<String>> parameters = this.urlQueryStringParser.parse(url);
        List<String> xpage = parameters.remove("xpage");
        if (!(xpage == null || xpage.isEmpty() || StringUtils.isEmpty((CharSequence)xpage.get(0)) || "plain".equals(xpage.get(0)))) {
            source.setParameter("template", (Object)(xpage.get(0) + ".vm"));
            String documentReference = this.urlDocumentReferenceResolver.resolve(url);
            if (documentReference != null) {
                source.setParameter("$doc", (Object)documentReference);
            }
            for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                if (entry.getValue().size() > 1) {
                    source.setParameter(entry.getKey(), entry.getValue());
                    continue;
                }
                source.setParameter(entry.getKey(), (Object)entry.getValue().get(0));
            }
        }
    }

    private void processExtraParams(ObjectNode options, LiveDataQuery queryConfig) {
        JsonNode extraParamsNode = options.path("extraParams");
        if (extraParamsNode.isTextual()) {
            String extraParams = extraParamsNode.asText();
            try {
                ArrayList<LiveDataQuery.Filter> filters = new ArrayList<LiveDataQuery.Filter>();
                Map<String, List<String>> parameters = this.urlQueryStringParser.parse("?" + extraParams);
                for (Map.Entry<String, List<String>> entry : parameters.entrySet()) {
                    if (queryConfig.getProperties().contains(entry.getKey())) {
                        LiveDataQuery.Filter filter = new LiveDataQuery.Filter();
                        filter.setProperty(entry.getKey());
                        filter.getConstraints().addAll(entry.getValue().stream().map(LiveDataQuery.Constraint::new).collect(Collectors.toList()));
                        filters.add(filter);
                        continue;
                    }
                    if (entry.getValue().size() == 1) {
                        queryConfig.getSource().setParameter(entry.getKey(), (Object)entry.getValue().get(0));
                        continue;
                    }
                    queryConfig.getSource().setParameter(entry.getKey(), entry.getValue());
                }
                if (!filters.isEmpty()) {
                    queryConfig.setFilters(filters);
                }
            }
            catch (Exception e) {
                this.logger.warn("Failed to extract live data source parameters and property filters from live table extra parameters [{}]. Root cause is [{}].", (Object)extraParams, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    private List<LiveDataQuery.SortEntry> getSortConfig(ObjectNode options) {
        JsonNode selectedColumn = options.path("selectedColumn");
        JsonNode defaultOrder = options.path("defaultOrder");
        if (selectedColumn.isTextual() || defaultOrder.isTextual()) {
            LiveDataQuery.SortEntry sortEntry = new LiveDataQuery.SortEntry(selectedColumn.asText(), "desc".equals(defaultOrder.asText()));
            return Collections.singletonList(sortEntry);
        }
        return null;
    }

    private LiveDataMeta getMetaConfig(ObjectNode columnProperties, ObjectNode options) {
        LiveDataMeta metaConfig = new LiveDataMeta();
        metaConfig.setPropertyDescriptors(this.getPropertyDescriptorsConfig(columnProperties, options));
        metaConfig.setPagination(this.getPaginationConfig(options));
        return metaConfig;
    }

    private List<LiveDataPropertyDescriptor> getPropertyDescriptorsConfig(ObjectNode columnProperties, ObjectNode options) {
        ArrayList<LiveDataPropertyDescriptor> propertyDescriptors = new ArrayList<LiveDataPropertyDescriptor>();
        columnProperties.fields().forEachRemaining(field -> propertyDescriptors.add(this.getPropertyDescriptor((String)field.getKey(), (ObjectNode)field.getValue(), options)));
        return propertyDescriptors;
    }

    private LiveDataPropertyDescriptor getPropertyDescriptor(String column, ObjectNode columnProperties, ObjectNode options) {
        LiveDataPropertyDescriptor propertyDescriptor = new LiveDataPropertyDescriptor();
        propertyDescriptor.setId(column);
        propertyDescriptor.setName(this.getPropertyName(columnProperties));
        propertyDescriptor.setType(this.getPropertyType(column, columnProperties, options));
        propertyDescriptor.setSortable(Boolean.valueOf(columnProperties.path("sortable").asBoolean(!columnProperties.has(ACTIONS))));
        propertyDescriptor.setVisible(Boolean.valueOf(!HIDDEN.equals(columnProperties.path(TYPE).asText())));
        propertyDescriptor.setDisplayer(this.getDisplayerConfig(column, columnProperties, options));
        propertyDescriptor.setFilterable(Boolean.valueOf(columnProperties.path("filterable").asBoolean(!columnProperties.has(ACTIONS))));
        propertyDescriptor.setFilter(this.getFilterConfig(columnProperties));
        propertyDescriptor.setStyleName(columnProperties.path("headerClass").asText(null));
        return propertyDescriptor;
    }

    private String getPropertyName(ObjectNode columnProperties) {
        JsonNode displayName = columnProperties.path("displayName");
        return displayName.isTextual() ? displayName.asText() : null;
    }

    private String getPropertyType(String column, ObjectNode columnProperties, ObjectNode options) {
        JsonNode className = columnProperties.path("class");
        if (!className.isTextual() && !(className = options.path(CLASS_NAME)).isTextual()) {
            return null;
        }
        return this.propertyTypeSupplier.getPropertyType(column, className.asText());
    }

    private LiveDataPropertyDescriptor.DisplayerDescriptor getDisplayerConfig(String column, ObjectNode columnProperties, ObjectNode options) {
        LiveDataPropertyDescriptor.DisplayerDescriptor displayerConfig = new LiveDataPropertyDescriptor.DisplayerDescriptor();
        if (columnProperties.path(ACTIONS).isArray()) {
            displayerConfig.setId(ACTIONS);
            displayerConfig.setParameter(ACTIONS, columnProperties.get(ACTIONS).valueStream().map(JsonNode::asText).toList());
        } else if (columnProperties.path(LINK).isTextual()) {
            displayerConfig.setId(LINK);
            displayerConfig.setParameter("propertyHref", this.getLinkTarget(column, columnProperties.get(LINK).asText()));
            displayerConfig.setParameter(HTML, (Object)columnProperties.path(HTML).booleanValue());
        } else if (columnProperties.path(HTML).booleanValue()) {
            if (StringUtils.isNotEmpty((CharSequence)options.path(CLASS_NAME).textValue())) {
                displayerConfig.setId("xObjectProperty");
            } else {
                displayerConfig.setId(HTML);
            }
        } else {
            displayerConfig = null;
        }
        return displayerConfig;
    }

    private Object getLinkTarget(String column, String linkType) {
        String docURL = "doc.url";
        String columnURL = column + "_url";
        if ("auto".equals(linkType)) {
            return List.of(columnURL, docURL);
        }
        if ("field".equals(linkType)) {
            return columnURL;
        }
        String linkTypeURL = String.format("doc.%s_url", linkType);
        return List.of(linkTypeURL, docURL);
    }

    private LiveDataPropertyDescriptor.FilterDescriptor getFilterConfig(ObjectNode columnProperties) {
        String defaultOperator;
        JsonNode match;
        LiveDataPropertyDescriptor.FilterDescriptor filterConfig = new LiveDataPropertyDescriptor.FilterDescriptor();
        boolean hasFilter = false;
        JsonNode filterId = columnProperties.path(TYPE);
        if (filterId.isTextual() && !HIDDEN.equals(filterId.asText())) {
            filterConfig.setId(filterId.asText());
            hasFilter = true;
        }
        if ((match = columnProperties.path("match")).isTextual() && (defaultOperator = DEFAULT_OPERATOR.get(match.asText())) != null) {
            filterConfig.setDefaultOperator(defaultOperator);
            hasFilter = true;
        }
        return hasFilter ? filterConfig : null;
    }

    private LiveDataPaginationConfiguration getPaginationConfig(ObjectNode options) {
        LiveDataPaginationConfiguration pagination = new LiveDataPaginationConfiguration();
        pagination.setMaxShownPages(Integer.valueOf(options.path("maxPages").asInt(10)));
        boolean showPageSizeDropdown = options.path("pageSize").asBoolean(true);
        pagination.setShowPageSizeDropdown(Boolean.valueOf(showPageSizeDropdown));
        JsonNode pageSizeBounds = options.path("pageSizeBounds");
        int min = 10;
        int max = 100;
        int step = 10;
        if (pageSizeBounds.isArray() && pageSizeBounds.size() == 3) {
            min = pageSizeBounds.get(0).asInt();
            max = pageSizeBounds.get(1).asInt();
            step = pageSizeBounds.get(2).asInt();
        }
        if (showPageSizeDropdown && min <= max && step > 0) {
            ArrayList<Integer> pageSizes = new ArrayList<Integer>();
            for (int i = min; i <= max; i += step) {
                pageSizes.add(i);
            }
            pagination.setPageSizes(pageSizes);
        }
        return pagination;
    }
}

