/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal.script;

import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataQuery;

@Component(roles={LiveDataConfigHelper.class})
@Singleton
public class LiveDataConfigHelper {
    @Inject
    private LiveDataConfigurationResolver<String> stringConfigResolver;
    @Inject
    private LiveDataConfigurationResolver<LiveDataConfiguration> defaultConfigResolver;

    public LiveDataQuery createQuery(Map<String, Object> queryConfig) throws Exception {
        return this.createQuery(new ObjectMapper().writeValueAsString(queryConfig));
    }

    public LiveDataQuery createQuery(String queryConfigJSON) throws Exception {
        String liveDataConfigJSON = "{\"query\": " + queryConfigJSON + "}";
        LiveDataConfiguration liveDataConfig = this.defaultConfigResolver.resolve(this.stringConfigResolver.resolve(liveDataConfigJSON));
        return liveDataConfig.getQuery();
    }

    public Map<String, Object> effectiveConfig(Map<String, Object> liveDataConfig) throws Exception {
        ObjectMapper objectMapper = new ObjectMapper();
        String effectiveConfigJSON = this.effectiveConfig(objectMapper.writeValueAsString(liveDataConfig));
        return (Map)objectMapper.readerForMapOf(Object.class).readValue(effectiveConfigJSON);
    }

    public String effectiveConfig(String liveDataConfigJSON) throws Exception {
        LiveDataConfiguration liveDataConfig = this.defaultConfigResolver.resolve(this.stringConfigResolver.resolve(liveDataConfigJSON));
        ObjectMapper objectMapper = new ObjectMapper();
        objectMapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return objectMapper.writeValueAsString((Object)liveDataConfig);
    }
}

