/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;

@Component
@Singleton
public class MapLiveDataConfigurationResolver
implements LiveDataConfigurationResolver<Map<String, Object>> {
    @Inject
    private LiveDataConfigurationResolver<String> stringConfigResolver;

    @Override
    public LiveDataConfiguration resolve(Map<String, Object> input) throws LiveDataException {
        ObjectMapper objectMapper = new ObjectMapper();
        try {
            return this.stringConfigResolver.resolve(objectMapper.writeValueAsString(input));
        }
        catch (JsonProcessingException e) {
            throw new LiveDataException(e);
        }
    }
}

