/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal;

import java.net.URL;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.livedata.BaseDescriptor;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataLayoutDescriptor;
import org.xwiki.livedata.LiveDataMeta;
import org.xwiki.livedata.LiveDataPaginationConfiguration;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.internal.JSONMerge;
import org.xwiki.livedata.internal.LiveDataRendererParameters;

@Component(roles={LiveDataRendererConfiguration.class})
@Singleton
public class LiveDataRendererConfiguration {
    private static final String UTF8 = "UTF-8";
    @Inject
    private LiveDataConfigurationResolver<String> stringLiveDataConfigResolver;
    private JSONMerge jsonMerge = new JSONMerge();

    public LiveDataConfiguration getLiveDataConfiguration(String content, LiveDataRendererParameters parameters) throws Exception {
        String json = (String)StringUtils.defaultIfBlank((CharSequence)content, (CharSequence)"{}");
        LiveDataConfiguration advancedConfig = this.stringLiveDataConfigResolver.resolve(json);
        LiveDataConfiguration basicConfig = this.getLiveDataConfiguration(parameters);
        advancedConfig.setId(basicConfig.getId());
        return this.jsonMerge.merge(new LiveDataConfiguration[]{advancedConfig, basicConfig});
    }

    public LiveDataConfiguration getLiveDataConfiguration(LiveDataRendererParameters parameters) throws Exception {
        LiveDataConfiguration liveDataConfig = new LiveDataConfiguration();
        liveDataConfig.setId(parameters.getId());
        liveDataConfig.setQuery(this.getQuery(parameters));
        liveDataConfig.setMeta(this.getMeta(parameters));
        return liveDataConfig;
    }

    private LiveDataQuery getQuery(LiveDataRendererParameters parameters) throws Exception {
        LiveDataQuery query = new LiveDataQuery();
        query.setProperties(this.getProperties(parameters.getProperties()));
        query.setSource(new LiveDataQuery.Source(parameters.getSource()));
        query.getSource().getParameters().putAll(this.getSourceParameters(parameters.getSourceParameters()));
        query.setSort(this.getSortEntries(parameters.getSort()));
        query.setFilters(this.getFilters(parameters.getFilters()));
        query.setLimit(parameters.getLimit());
        query.setOffset(parameters.getOffset());
        return query;
    }

    private List<String> getProperties(String properties) {
        if (properties == null) {
            return null;
        }
        return this.getSplitStringStream(properties).collect(Collectors.toList());
    }

    private Map<String, Object> getSourceParameters(String sourceParametersString) throws Exception {
        if (StringUtils.isEmpty((CharSequence)sourceParametersString)) {
            return Collections.emptyMap();
        }
        Map<String, List<String>> urlParams = this.getURLParameters("?" + sourceParametersString);
        HashMap<String, Object> sourceParams = new HashMap<String, Object>();
        for (Map.Entry<String, List<String>> entry : urlParams.entrySet()) {
            if (entry.getValue().size() > 1) {
                sourceParams.put(entry.getKey(), entry.getValue());
                continue;
            }
            sourceParams.put(entry.getKey(), entry.getValue().get(0));
        }
        return sourceParams;
    }

    private List<LiveDataQuery.SortEntry> getSortEntries(String sort) {
        if (sort == null) {
            return null;
        }
        return this.getSplitStringStream(sort).filter(StringUtils::isNotEmpty).map(this::getSortEntry).collect(Collectors.toList());
    }

    private LiveDataQuery.SortEntry getSortEntry(String sortEntryString) {
        LiveDataQuery.SortEntry sortEntry = new LiveDataQuery.SortEntry();
        sortEntry.setDescending(sortEntryString.endsWith(":desc"));
        if (sortEntry.isDescending() || sortEntryString.endsWith(":asc")) {
            sortEntry.setProperty(StringUtils.substringBeforeLast((String)sortEntryString, (String)":"));
        } else {
            sortEntry.setProperty(sortEntryString);
        }
        return sortEntry;
    }

    private List<LiveDataQuery.Filter> getFilters(String filtersString) throws Exception {
        List<LiveDataQuery.Filter> filters = this.getURLParameters("?" + StringUtils.defaultString((String)filtersString)).entrySet().stream().map(this::getFilter).collect(Collectors.toList());
        return filters.isEmpty() ? null : filters;
    }

    private LiveDataQuery.Filter getFilter(Map.Entry<String, List<String>> entry) {
        LiveDataQuery.Filter filter = new LiveDataQuery.Filter();
        filter.setProperty(entry.getKey());
        filter.getConstraints().addAll(entry.getValue().stream().map(LiveDataQuery.Constraint::new).collect(Collectors.toList()));
        return filter;
    }

    private LiveDataMeta getMeta(LiveDataRendererParameters parameters) {
        LiveDataMeta meta = new LiveDataMeta();
        List<LiveDataLayoutDescriptor> layouts = this.getLayouts(parameters);
        meta.setLayouts(layouts);
        Optional.ofNullable(layouts).flatMap(ls -> ls.stream().findFirst().map(BaseDescriptor::getId)).ifPresent(meta::setDefaultLayout);
        meta.setPagination(this.getPagination(parameters));
        String description = parameters.getDescription();
        if (StringUtils.isNoneEmpty((CharSequence[])new CharSequence[]{description})) {
            meta.setDescription(description);
        }
        return meta;
    }

    private List<LiveDataLayoutDescriptor> getLayouts(LiveDataRendererParameters parameters) {
        if (parameters.getLayouts() == null) {
            return null;
        }
        return this.getSplitStringStream(parameters.getLayouts()).map(LiveDataLayoutDescriptor::new).collect(Collectors.toList());
    }

    private LiveDataPaginationConfiguration getPagination(LiveDataRendererParameters parameters) {
        LiveDataPaginationConfiguration pagination = new LiveDataPaginationConfiguration();
        pagination.setShowPageSizeDropdown(parameters.getShowPageSizeDropdown());
        if (parameters.getPageSizes() != null) {
            pagination.setPageSizes(this.getSplitStringStream(parameters.getPageSizes()).map(Integer::parseInt).collect(Collectors.toList()));
        }
        return pagination;
    }

    private Map<String, List<String>> getURLParameters(String url) throws Exception {
        URL baseURL = new URL("http://www.xwiki.org");
        String queryString = new URL(baseURL, url).getQuery();
        HashMap<String, List<String>> parameters = new HashMap<String, List<String>>();
        for (String entry : queryString.split("&")) {
            String[] parts = entry.split("=", 2);
            String key = URLDecoder.decode(parts[0], UTF8);
            if (key.isEmpty()) continue;
            String value = parts.length == 2 ? URLDecoder.decode(parts[1], UTF8) : "";
            ArrayList<String> values = (ArrayList<String>)parameters.get(key);
            if (values == null) {
                values = new ArrayList<String>();
                parameters.put(key, values);
            }
            values.add(value);
        }
        return parameters;
    }

    private Stream<String> getSplitStringStream(String commaListAsString) {
        return Stream.of(commaListAsString.split(",")).map(StringUtils::trim);
    }
}

