/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Collections;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.livedata.LiveDataConfiguration;
import org.xwiki.livedata.LiveDataConfigurationResolver;
import org.xwiki.livedata.LiveDataException;
import org.xwiki.livedata.internal.LiveDataRendererConfiguration;
import org.xwiki.livedata.internal.LiveDataRendererParameters;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;
import org.xwiki.rendering.transformation.RenderingContext;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;
import org.xwiki.skinx.SkinExtension;

@Component(roles={LiveDataRenderer.class})
@Singleton
public class LiveDataRenderer {
    @Inject
    private LiveDataConfigurationResolver<LiveDataConfiguration> defaultLiveDataConfigResolver;
    @Inject
    private LiveDataRendererConfiguration liveDataRendererConfiguration;
    @Inject
    private ContextualAuthorizationManager contextualAuthorizationManager;
    @Inject
    @Named(value="jsfx")
    private SkinExtension jsfx;
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> componentManagerProvider;
    @Inject
    private RenderingContext renderingContext;

    public Block execute(LiveDataRendererParameters parameters, Map<?, ?> advancedParameters, boolean restricted) throws LiveDataException {
        try {
            return this.execute(parameters, new ObjectMapper().writeValueAsString(advancedParameters), restricted);
        }
        catch (JsonProcessingException e) {
            throw new LiveDataException("Failed to to serialize the advanced parameters [%s] to json.".formatted(advancedParameters), e);
        }
    }

    public Block execute(LiveDataRendererParameters parameters, String advancedParameters, boolean restricted) throws LiveDataException {
        Map<String, Boolean> skinExtensionParameters = Collections.singletonMap("forceSkinAction", Boolean.TRUE);
        this.jsfx.use("uicomponents/widgets/liveData.js", skinExtensionParameters);
        GroupBlock output = new GroupBlock();
        output.setParameter("class", "liveData loading");
        if (parameters.getId() != null) {
            output.setParameter("id", parameters.getId());
        }
        try {
            LiveDataConfiguration liveDataConfig = this.liveDataRendererConfiguration.getLiveDataConfiguration(advancedParameters, parameters);
            liveDataConfig = this.defaultLiveDataConfigResolver.resolve(liveDataConfig);
            ObjectMapper objectMapper = new ObjectMapper();
            output.setParameter("data-config", objectMapper.writeValueAsString((Object)liveDataConfig));
            boolean trustedContent = StringUtils.isBlank((CharSequence)advancedParameters) || this.contextualAuthorizationManager.hasAccess(Right.SCRIPT) && !restricted;
            output.setParameter("data-config-content-trusted", Boolean.toString(trustedContent));
        }
        catch (Exception e) {
            throw new LiveDataException("Failed to generate live data configuration from macro parameters.", e);
        }
        return output;
    }

    public String render(LiveDataRendererParameters parameters, Map<?, ?> advancedParameters, boolean restricted) throws LiveDataException {
        String hint = this.renderingContext.getTargetSyntax().toIdString();
        try {
            BlockRenderer renderer = (BlockRenderer)((ComponentManager)this.componentManagerProvider.get()).getInstance(BlockRenderer.class, hint);
            Block block = this.execute(parameters, advancedParameters, restricted);
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            renderer.render(block, (WikiPrinter)printer);
            return printer.toString();
        }
        catch (ComponentLookupException e) {
            throw new LiveDataException("Failed to resolve [%s] with hint [%s]".formatted(BlockRenderer.class, hint), e);
        }
    }
}

