/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata.internal;

import java.util.Collection;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.internal.multi.ComponentManagerManager;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.livedata.LiveDataQuery;
import org.xwiki.livedata.LiveDataSource;
import org.xwiki.livedata.LiveDataSourceManager;
import org.xwiki.livedata.WithParameters;

@Component
@Singleton
public class DefaultLiveDataSourceManager
implements LiveDataSourceManager {
    @Inject
    @Named(value="context")
    private Provider<ComponentManager> contextComponentManagerProvider;
    @Inject
    private ComponentManagerManager componentManagerManager;
    @Inject
    private Logger logger;

    @Override
    public Optional<LiveDataSource> get(LiveDataQuery.Source sourceConfig, String namespace) {
        ComponentManager cm = this.getComponentManager(namespace);
        if (cm != null && cm.hasComponent(LiveDataSource.class, sourceConfig.getId())) {
            try {
                LiveDataSource liveDataSource = (LiveDataSource)cm.getInstance(LiveDataSource.class, sourceConfig.getId());
                if (liveDataSource instanceof WithParameters) {
                    ((WithParameters)((Object)liveDataSource)).getParameters().putAll(sourceConfig.getParameters());
                }
                return Optional.of(liveDataSource);
            }
            catch (ComponentLookupException e) {
                this.logger.error("Error when initializing LiveDataSource with hint [{}]", (Object)sourceConfig.getId(), (Object)e);
            }
        }
        return Optional.empty();
    }

    @Override
    public Optional<Collection<String>> getAvailableSources(String namespace) {
        ComponentManager cm = this.getComponentManager(namespace);
        if (cm == null) {
            return Optional.empty();
        }
        return Optional.of((Collection)cm.getComponentDescriptorList(LiveDataSource.class).stream().map(descriptor -> descriptor.getRoleHint()).collect(Collectors.toSet()));
    }

    private ComponentManager getComponentManager(String namespace) {
        return "".equals(namespace) ? (ComponentManager)this.contextComponentManagerProvider.get() : this.componentManagerManager.getComponentManager(namespace, false);
    }
}

