/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.livedata.BaseDescriptor;
import org.xwiki.livedata.InitializableLiveDataElement;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LiveDataQuery
implements InitializableLiveDataElement {
    private List<String> properties;
    private Source source;
    private List<Filter> filters;
    private List<SortEntry> sort;
    private Long offset;
    private Integer limit;

    public Long getOffset() {
        return this.offset;
    }

    public void setOffset(Long offset) {
        this.offset = offset;
    }

    public Integer getLimit() {
        return this.limit;
    }

    public void setLimit(Integer limit) {
        this.limit = limit;
    }

    public List<String> getProperties() {
        return this.properties;
    }

    public void setProperties(List<String> properties) {
        this.properties = properties;
    }

    public Source getSource() {
        return this.source;
    }

    public void setSource(Source source) {
        this.source = source;
    }

    public List<Filter> getFilters() {
        return this.filters;
    }

    public void setFilters(List<Filter> filters) {
        this.filters = filters;
    }

    public List<SortEntry> getSort() {
        return this.sort;
    }

    public void setSort(List<SortEntry> sort) {
        this.sort = sort;
    }

    @Override
    public void initialize() {
        if (this.properties == null) {
            this.properties = new ArrayList<String>();
        }
        if (this.source == null) {
            this.source = new Source();
        }
        if (this.filters == null) {
            this.filters = new ArrayList<Filter>();
        }
        if (this.sort == null) {
            this.sort = new ArrayList<SortEntry>();
        }
        if (this.offset == null) {
            this.offset = 0L;
        }
        if (this.limit == null) {
            this.limit = 15;
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveDataQuery that = (LiveDataQuery)o;
        return new EqualsBuilder().append(this.properties, that.properties).append((Object)this.source, (Object)that.source).append(this.filters, that.filters).append(this.sort, that.sort).append((Object)this.offset, (Object)that.offset).append((Object)this.limit, (Object)that.limit).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.properties).append((Object)this.source).append(this.filters).append(this.sort).append((Object)this.offset).append((Object)this.limit).toHashCode();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Source
    extends BaseDescriptor {
        public Source() {
        }

        public Source(String id) {
            this.setId(id);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class SortEntry {
        private String property;
        private boolean descending;

        public SortEntry() {
        }

        public SortEntry(String property) {
            this.property = property;
        }

        public SortEntry(String property, boolean descending) {
            this.property = property;
            this.descending = descending;
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public boolean isDescending() {
            return this.descending;
        }

        public void setDescending(boolean descending) {
            this.descending = descending;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            SortEntry sortEntry = (SortEntry)o;
            return new EqualsBuilder().append(this.descending, sortEntry.descending).append((Object)this.property, (Object)sortEntry.property).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.property).append(this.descending).toHashCode();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class Constraint {
        private String operator;
        private Object value;

        public Constraint() {
        }

        public Constraint(Object value) {
            this(value, null);
        }

        public Constraint(Object value, String operator) {
            this.value = value;
            this.operator = operator;
        }

        public String getOperator() {
            return this.operator;
        }

        public void setOperator(String operator) {
            this.operator = operator;
        }

        public Object getValue() {
            return this.value;
        }

        public void setValue(Object value) {
            this.value = value;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Constraint that = (Constraint)o;
            return new EqualsBuilder().append((Object)this.operator, (Object)that.operator).append(this.value, that.value).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.operator).append(this.value).toHashCode();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_DEFAULT)
    public static class Filter {
        private String property;
        private boolean matchAll;
        private final List<Constraint> constraints = new ArrayList<Constraint>();

        public Filter() {
        }

        public Filter(String property, Object value) {
            this.property = property;
            this.constraints.add(new Constraint(value));
        }

        public Filter(String property, String operator, Object value) {
            this.property = property;
            this.constraints.add(new Constraint(value, operator));
        }

        public Filter(String property, boolean matchAll, Object ... values) {
            this.property = property;
            this.matchAll = matchAll;
            Stream.of(values).map(Constraint::new).forEach(this.constraints::add);
        }

        public Filter(String property, String operator, boolean matchAll, Object ... values) {
            this.property = property;
            this.matchAll = matchAll;
            Stream.of(values).map(value -> new Constraint(value, operator)).forEach(this.constraints::add);
        }

        public String getProperty() {
            return this.property;
        }

        public void setProperty(String property) {
            this.property = property;
        }

        public boolean isMatchAll() {
            return this.matchAll;
        }

        public void setMatchAll(boolean matchAll) {
            this.matchAll = matchAll;
        }

        public List<Constraint> getConstraints() {
            return this.constraints;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            Filter filter = (Filter)o;
            return new EqualsBuilder().append(this.matchAll, filter.matchAll).append((Object)this.property, (Object)filter.property).append(this.constraints, filter.constraints).isEquals();
        }

        public int hashCode() {
            return new HashCodeBuilder(17, 37).append((Object)this.property).append(this.matchAll).append(this.constraints).toHashCode();
        }
    }
}

