/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.livedata.BaseDescriptor;
import org.xwiki.livedata.InitializableLiveDataElement;
import org.xwiki.text.XWikiToStringBuilder;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LiveDataPropertyDescriptor
implements InitializableLiveDataElement {
    private static final String NAME_CONSTANT = "name";
    private String id;
    private String name;
    private String description;
    private Map<String, Object> icon;
    private String type;
    private Boolean sortable;
    private Boolean visible;
    private Boolean filterable;
    private Boolean editable;
    private DisplayerDescriptor displayer;
    private FilterDescriptor filter;
    private String styleName;

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getType() {
        return this.type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public Boolean isSortable() {
        return this.sortable;
    }

    public void setSortable(Boolean sortable) {
        this.sortable = sortable;
    }

    public String getStyleName() {
        return this.styleName;
    }

    public void setStyleName(String styleName) {
        this.styleName = styleName;
    }

    public Map<String, Object> getIcon() {
        return this.icon;
    }

    public void setIcon(Map<String, Object> icon) {
        this.icon = icon;
    }

    public Boolean isVisible() {
        return this.visible;
    }

    public void setVisible(Boolean visible) {
        this.visible = visible;
    }

    public DisplayerDescriptor getDisplayer() {
        return this.displayer;
    }

    public void setDisplayer(DisplayerDescriptor displayer) {
        this.displayer = displayer;
    }

    public Boolean isFilterable() {
        return this.filterable;
    }

    public void setFilterable(Boolean filterable) {
        this.filterable = filterable;
    }

    public FilterDescriptor getFilter() {
        return this.filter;
    }

    public void setFilter(FilterDescriptor filter) {
        this.filter = filter;
    }

    public Boolean isEditable() {
        return this.editable;
    }

    public void setEditable(Boolean editable) {
        this.editable = editable;
    }

    @Override
    public void initialize() {
        if (this.visible == null) {
            this.visible = true;
        }
        if (this.icon == null) {
            this.icon = new HashMap<String, Object>();
        }
        if (this.displayer == null) {
            this.displayer = new DisplayerDescriptor();
        }
        if (this.filter == null) {
            this.filter = new FilterDescriptor();
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveDataPropertyDescriptor that = (LiveDataPropertyDescriptor)o;
        return new EqualsBuilder().append((Object)this.id, (Object)that.id).append((Object)this.name, (Object)that.name).append((Object)this.description, (Object)that.description).append(this.icon, that.icon).append((Object)this.type, (Object)that.type).append((Object)this.sortable, (Object)that.sortable).append((Object)this.visible, (Object)that.visible).append((Object)this.filterable, (Object)that.filterable).append((Object)this.editable, (Object)that.editable).append((Object)this.displayer, (Object)that.displayer).append((Object)this.filter, (Object)that.filter).append((Object)this.styleName, (Object)that.styleName).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(27, 37).append((Object)this.id).append((Object)this.name).append((Object)this.description).append(this.icon).append((Object)this.type).append((Object)this.sortable).append((Object)this.visible).append((Object)this.filterable).append((Object)this.editable).append((Object)this.displayer).append((Object)this.filter).append((Object)this.styleName).toHashCode();
    }

    public String toString() {
        return new XWikiToStringBuilder((Object)this).appendSuper(super.toString()).append("id", (Object)this.id).append(NAME_CONSTANT, (Object)this.name).append("description", (Object)this.description).append("icon", this.icon).append("type", (Object)this.type).append("sortable", (Object)this.sortable).append("visible", (Object)this.visible).append("filterable", (Object)this.filterable).append("editable", (Object)this.editable).append("displayer", (Object)this.displayer).append("filter", (Object)this.filter).append("styleName", (Object)this.styleName).toString();
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class DisplayerDescriptor
    extends BaseDescriptor {
        public DisplayerDescriptor() {
        }

        public DisplayerDescriptor(String id) {
            this.setId(id);
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class FilterDescriptor
    extends BaseDescriptor
    implements InitializableLiveDataElement {
        private String defaultOperator;
        private List<OperatorDescriptor> operators;

        public FilterDescriptor() {
        }

        public FilterDescriptor(String id) {
            this.setId(id);
        }

        public List<OperatorDescriptor> getOperators() {
            return this.operators;
        }

        public void setOperators(List<OperatorDescriptor> operators) {
            this.operators = operators;
        }

        public OperatorDescriptor addOperator(String id, String name) {
            OperatorDescriptor operator = new OperatorDescriptor(id, name);
            if (this.operators == null) {
                this.operators = new ArrayList<OperatorDescriptor>();
            }
            this.operators.add(operator);
            return operator;
        }

        public String getDefaultOperator() {
            return this.defaultOperator;
        }

        public void setDefaultOperator(String defaultOperator) {
            this.defaultOperator = defaultOperator;
        }

        @Override
        public void initialize() {
            if (this.operators == null) {
                this.operators = new ArrayList<OperatorDescriptor>();
            }
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            FilterDescriptor that = (FilterDescriptor)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.defaultOperator, (Object)that.defaultOperator).append(this.operators, that.operators).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(23, 87).appendSuper(super.hashCode()).append((Object)this.defaultOperator).append(this.operators).toHashCode();
        }

        @Override
        public String toString() {
            return new XWikiToStringBuilder((Object)this).appendSuper(super.toString()).append("defaultOperator", (Object)this.defaultOperator).append("operators", this.operators).toString();
        }
    }

    @JsonInclude(value=JsonInclude.Include.NON_NULL)
    public static class OperatorDescriptor
    extends BaseDescriptor {
        private String name;

        public OperatorDescriptor() {
        }

        public OperatorDescriptor(String id, String name) {
            this.setId(id);
            this.setName(name);
        }

        public String getName() {
            return this.name;
        }

        public void setName(String name) {
            this.name = name;
        }

        @Override
        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            OperatorDescriptor that = (OperatorDescriptor)o;
            return new EqualsBuilder().appendSuper(super.equals(o)).append((Object)this.name, (Object)that.name).isEquals();
        }

        @Override
        public int hashCode() {
            return new HashCodeBuilder(17, 69).appendSuper(super.hashCode()).append((Object)this.name).toHashCode();
        }

        @Override
        public String toString() {
            return new XWikiToStringBuilder((Object)this).appendSuper(super.toString()).append(LiveDataPropertyDescriptor.NAME_CONSTANT, (Object)this.name).toString();
        }
    }
}

