/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.livedata;

import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import com.fasterxml.jackson.annotation.JsonInclude;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.livedata.InitializableLiveDataElement;
import org.xwiki.livedata.LiveDataActionDescriptor;
import org.xwiki.livedata.LiveDataEntryDescriptor;
import org.xwiki.livedata.LiveDataLayoutDescriptor;
import org.xwiki.livedata.LiveDataPaginationConfiguration;
import org.xwiki.livedata.LiveDataPropertyDescriptor;
import org.xwiki.livedata.LiveDataSelectionConfiguration;
import org.xwiki.stability.Unstable;

@JsonInclude(value=JsonInclude.Include.NON_NULL)
@JsonIgnoreProperties(ignoreUnknown=true)
public class LiveDataMeta
implements InitializableLiveDataElement {
    private Collection<LiveDataLayoutDescriptor> layouts;
    private String defaultLayout;
    private Collection<LiveDataPropertyDescriptor> propertyDescriptors;
    private Collection<LiveDataPropertyDescriptor> propertyTypes;
    private Collection<LiveDataPropertyDescriptor.FilterDescriptor> filters;
    private String defaultFilter;
    private Collection<LiveDataPropertyDescriptor.DisplayerDescriptor> displayers;
    private String defaultDisplayer;
    private LiveDataPaginationConfiguration pagination;
    private LiveDataEntryDescriptor entryDescriptor;
    private Collection<LiveDataActionDescriptor> actions;
    private LiveDataSelectionConfiguration selection;
    private String description;

    public String getDefaultLayout() {
        return this.defaultLayout;
    }

    public void setDefaultLayout(String defaultLayout) {
        this.defaultLayout = defaultLayout;
    }

    public String getDefaultFilter() {
        return this.defaultFilter;
    }

    public void setDefaultFilter(String defaultFilter) {
        this.defaultFilter = defaultFilter;
    }

    public String getDefaultDisplayer() {
        return this.defaultDisplayer;
    }

    public void setDefaultDisplayer(String defaultDisplayer) {
        this.defaultDisplayer = defaultDisplayer;
    }

    public Collection<LiveDataLayoutDescriptor> getLayouts() {
        return this.layouts;
    }

    public void setLayouts(Collection<LiveDataLayoutDescriptor> layouts) {
        this.layouts = layouts;
    }

    public Collection<LiveDataPropertyDescriptor> getPropertyDescriptors() {
        return this.propertyDescriptors;
    }

    public void setPropertyDescriptors(Collection<LiveDataPropertyDescriptor> propertyDescriptors) {
        this.propertyDescriptors = propertyDescriptors;
    }

    public Collection<LiveDataPropertyDescriptor> getPropertyTypes() {
        return this.propertyTypes;
    }

    public void setPropertyTypes(Collection<LiveDataPropertyDescriptor> propertyTypes) {
        this.propertyTypes = propertyTypes;
    }

    public Collection<LiveDataPropertyDescriptor.FilterDescriptor> getFilters() {
        return this.filters;
    }

    public void setFilters(Collection<LiveDataPropertyDescriptor.FilterDescriptor> filters) {
        this.filters = filters;
    }

    public Collection<LiveDataPropertyDescriptor.DisplayerDescriptor> getDisplayers() {
        return this.displayers;
    }

    public void setDisplayers(Collection<LiveDataPropertyDescriptor.DisplayerDescriptor> displayers) {
        this.displayers = displayers;
    }

    public LiveDataPaginationConfiguration getPagination() {
        return this.pagination;
    }

    public void setPagination(LiveDataPaginationConfiguration pagination) {
        this.pagination = pagination;
    }

    public LiveDataEntryDescriptor getEntryDescriptor() {
        return this.entryDescriptor;
    }

    public void setEntryDescriptor(LiveDataEntryDescriptor entryDescriptor) {
        this.entryDescriptor = entryDescriptor;
    }

    public Collection<LiveDataActionDescriptor> getActions() {
        return this.actions;
    }

    public void setActions(Collection<LiveDataActionDescriptor> actions) {
        this.actions = actions;
    }

    public LiveDataSelectionConfiguration getSelection() {
        return this.selection;
    }

    public void setSelection(LiveDataSelectionConfiguration selection) {
        this.selection = selection;
    }

    @Unstable
    public String getDescription() {
        return this.description;
    }

    @Unstable
    public void setDescription(String description) {
        this.description = description;
    }

    private <A extends InitializableLiveDataElement> Collection<A> initializeAndCleanUpCollection(Collection<A> collection) {
        Collection<A> result;
        if (collection == null) {
            result = new ArrayList<A>();
        } else {
            result = collection;
            result.stream().filter(Objects::nonNull).forEach(InitializableLiveDataElement::initialize);
        }
        return result;
    }

    private <A extends InitializableLiveDataElement> A initialize(A descriptor, A newInstance) {
        A result = descriptor;
        if (result == null) {
            result = newInstance;
        }
        result.initialize();
        return result;
    }

    @Override
    public void initialize() {
        this.layouts = this.initializeAndCleanUpCollection(this.layouts);
        this.propertyDescriptors = this.initializeAndCleanUpCollection(this.propertyDescriptors);
        this.propertyTypes = this.initializeAndCleanUpCollection(this.propertyTypes);
        this.filters = this.initializeAndCleanUpCollection(this.filters);
        this.actions = this.initializeAndCleanUpCollection(this.actions);
        if (this.displayers == null) {
            this.displayers = new ArrayList<LiveDataPropertyDescriptor.DisplayerDescriptor>();
        }
        this.pagination = this.initialize(this.pagination, new LiveDataPaginationConfiguration());
        this.entryDescriptor = this.initialize(this.entryDescriptor, new LiveDataEntryDescriptor());
        this.selection = this.initialize(this.selection, new LiveDataSelectionConfiguration());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        LiveDataMeta that = (LiveDataMeta)o;
        return new EqualsBuilder().append(this.layouts, that.layouts).append((Object)this.defaultLayout, (Object)that.defaultLayout).append(this.propertyDescriptors, that.propertyDescriptors).append(this.propertyTypes, that.propertyTypes).append(this.filters, that.filters).append((Object)this.defaultFilter, (Object)that.defaultFilter).append(this.displayers, that.displayers).append((Object)this.defaultDisplayer, (Object)that.defaultDisplayer).append((Object)this.pagination, (Object)that.pagination).append((Object)this.entryDescriptor, (Object)that.entryDescriptor).append(this.actions, that.actions).append((Object)this.selection, (Object)that.selection).append((Object)this.description, (Object)that.description).isEquals();
    }

    public int hashCode() {
        return new HashCodeBuilder(17, 37).append(this.layouts).append((Object)this.defaultLayout).append(this.propertyDescriptors).append(this.propertyTypes).append(this.filters).append((Object)this.defaultFilter).append(this.displayers).append((Object)this.defaultDisplayer).append((Object)this.pagination).append((Object)this.entryDescriptor).append(this.actions).append((Object)this.selection).append((Object)this.description).toHashCode();
    }
}

