/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.skin;

import com.xpn.xwiki.XWiki;
import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.XWikiException;
import com.xpn.xwiki.doc.XWikiDocument;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.lesscss.compiler.LESSCompilerException;
import org.xwiki.lesscss.internal.skin.DocumentSkinReference;
import org.xwiki.lesscss.internal.skin.FSSkinReference;
import org.xwiki.lesscss.internal.skin.SkinReference;
import org.xwiki.lesscss.internal.skin.SkinReferenceFactory;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.DocumentReferenceResolver;
import org.xwiki.model.reference.EntityReferenceSerializer;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Component
@Singleton
public class DefaultSkinReferenceFactory
implements SkinReferenceFactory {
    @Inject
    private Provider<XWikiContext> xcontextProvider;
    @Inject
    private DocumentReferenceResolver<String> documentReferenceResolver;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;
    @Inject
    private EntityReferenceSerializer<String> entityReferenceSerializer;

    public SkinReference createReference(String skinName) throws LESSCompilerException {
        DocumentReference skinClassDocRef;
        XWikiDocument skinDoc;
        XWikiContext xcontext = (XWikiContext)this.xcontextProvider.get();
        XWiki xwiki = xcontext.getWiki();
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        DocumentReference skinDocRef = this.documentReferenceResolver.resolve((Object)skinName, new Object[]{new WikiReference(currentWikiId)});
        try {
            skinDoc = xwiki.getDocument(skinDocRef, xcontext);
        }
        catch (XWikiException e) {
            throw new LESSCompilerException(String.format("Unable to read document [%s]", skinDocRef), (Exception)((Object)e));
        }
        if (!skinDoc.isNew() && skinDoc.getXObjectSize(skinClassDocRef = new DocumentReference(skinDocRef.getWikiReference().getName(), "XWiki", "XWikiSkins")) > 0) {
            return this.createReference(skinDocRef);
        }
        return new FSSkinReference(skinName);
    }

    public SkinReference createReference(DocumentReference documentReference) {
        return new DocumentSkinReference(documentReference, this.entityReferenceSerializer);
    }
}

