/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.lesscss.internal.cache;

import java.util.Arrays;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.container.Container;
import org.xwiki.container.Request;
import org.xwiki.container.servlet.ServletRequest;
import org.xwiki.lesscss.internal.cache.XWikiContextCacheKeyFactory;
import org.xwiki.lesscss.internal.colortheme.ColorThemeReference;
import org.xwiki.lesscss.internal.skin.SkinReference;
import org.xwiki.lesscss.resources.LESSResourceReference;
import org.xwiki.text.StringUtils;

@Component(roles={CacheKeyFactory.class})
@Singleton
public class CacheKeyFactory {
    private static final String CACHE_KEY_SEPARATOR = "_";
    @Inject
    private XWikiContextCacheKeyFactory xcontextCacheKeyFactory;
    @Inject
    private Container container;

    public String getCacheKey(LESSResourceReference lessResourceReference, SkinReference skinReference, ColorThemeReference colorThemeReference, boolean withContext) {
        String lessResource = lessResourceReference.serialize();
        String skin = skinReference.serialize();
        String colorTheme = colorThemeReference.serialize();
        String result = lessResource.length() + CACHE_KEY_SEPARATOR + lessResource + CACHE_KEY_SEPARATOR + skin.length() + CACHE_KEY_SEPARATOR + skin + CACHE_KEY_SEPARATOR + colorTheme.length() + CACHE_KEY_SEPARATOR + colorTheme;
        if (withContext) {
            Request request = this.container.getRequest();
            List<String> excludes = Arrays.asList("skin", "colorTheme", "colorThemeVersion", "language", "docVersion", "cache-version");
            if (request instanceof ServletRequest) {
                Map parameters = ((ServletRequest)request).getHttpServletRequest().getParameterMap();
                for (Map.Entry entry : parameters.entrySet()) {
                    if (excludes.contains(entry.getKey())) continue;
                    Object[] values = (String[])entry.getValue();
                    result = result + CACHE_KEY_SEPARATOR + (String)entry.getKey() + ":" + StringUtils.join((Object[])values, (String)"|");
                }
            }
            String xcontext = this.xcontextCacheKeyFactory.getCacheKey();
            result = result + CACHE_KEY_SEPARATOR + xcontext.length() + CACHE_KEY_SEPARATOR + xcontext;
        }
        return result;
    }
}

