/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.url.internal.standard;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.configuration.ConfigurationSource;
import org.xwiki.url.internal.standard.DefaultStandardURLConfiguration;
import org.xwiki.url.internal.standard.WikiNotFoundBehavior;

@Component
@Singleton
public class LegacyStandardURLConfiguration
extends DefaultStandardURLConfiguration {
    @Inject
    @Named(value="xwikicfg")
    private ConfigurationSource xwikicfg;

    public boolean isPathBasedMultiWiki() {
        return super.isPathBasedMultiWiki(Boolean.valueOf("1".equals(this.xwikicfg.getProperty("xwiki.virtual.usepath", (Object)"1"))));
    }

    public String getWikiPathPrefix() {
        return super.getWikiPathPrefix((String)this.xwikicfg.getProperty("xwiki.virtual.usepath.servletpath", (Object)"wiki"));
    }

    public String getEntityPathPrefix() {
        String prefix = super.getWikiPathPrefix((String)this.xwikicfg.getProperty("xwiki.defaultservletpath", (Object)"bin"));
        prefix = StringUtils.removeEnd((String)prefix, (String)"/");
        return prefix;
    }

    public boolean isViewActionHidden() {
        return super.isViewActionHidden("0".equals(this.xwikicfg.getProperty("xwiki.showviewaction", (Object)"1")));
    }

    public WikiNotFoundBehavior getWikiNotFoundBehavior() {
        WikiNotFoundBehavior legacyBehavior = WikiNotFoundBehavior.DISPLAY_ERROR;
        String legacyValue = (String)this.xwikicfg.getProperty("xwiki.virtual.failOnWikiDoesNotExist", (Object)"0");
        if (!"1".equals(legacyValue)) {
            legacyBehavior = WikiNotFoundBehavior.REDIRECT_TO_MAIN_WIKI;
        }
        return super.getWikiNotFoundBehavior(legacyBehavior);
    }
}

