/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.objects.BaseObject;
import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.util.ReflectionUtils;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalysisResult;
import org.xwiki.platform.security.requiredrights.RequiredRightAnalyzer;
import org.xwiki.platform.security.requiredrights.RequiredRightsException;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.parser.ContentParser;
import org.xwiki.rendering.parser.MissingParserException;
import org.xwiki.rendering.parser.ParseException;

@Component
@Singleton
@Named(value="XWiki.WikiMacroParameterClass")
public class WikiMacroParameterObjectRequiredRightAnalyzer
implements RequiredRightAnalyzer<BaseObject> {
    @Inject
    private RequiredRightAnalyzer<XDOM> xdomRequiredRightAnalyzer;
    @Inject
    private ContentParser contentParser;

    public List<RequiredRightAnalysisResult> analyze(BaseObject object) throws RequiredRightsException {
        ArrayList<RequiredRightAnalysisResult> results = new ArrayList<RequiredRightAnalysisResult>(this.analyzeWikiContent(object, "description"));
        String type = object.getStringValue("type");
        try {
            if ("Wiki".equals(type) || StringUtils.contains((CharSequence)type, (CharSequence)"<") && Block.LIST_BLOCK_TYPE.equals(ReflectionUtils.unserializeType((String)type, (ClassLoader)Thread.currentThread().getContextClassLoader()))) {
                results.addAll(this.analyzeWikiContent(object, "defaultValue"));
            }
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return results;
    }

    private List<RequiredRightAnalysisResult> analyzeWikiContent(BaseObject object, String propertyName) throws RequiredRightsException {
        String value = object.getStringValue(propertyName);
        if (StringUtils.isNotBlank((CharSequence)value)) {
            EntityReference reference = object.getField(propertyName).getReference();
            try {
                XDOM parsedContent = this.contentParser.parse(value, object.getOwnerDocument().getSyntax(), (EntityReference)object.getDocumentReference());
                parsedContent.getMetaData().addMetaData("entityReference", (Object)reference);
                return this.xdomRequiredRightAnalyzer.analyze((Object)parsedContent);
            }
            catch (MissingParserException | ParseException e) {
                throw new RequiredRightsException("Failed to parse content of object property", e);
            }
        }
        return List.of();
    }
}

