/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.AbstractMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.macro.descriptor.ContentDescriptor;
import org.xwiki.rendering.macro.descriptor.DefaultContentDescriptor;
import org.xwiki.rendering.macro.wikibridge.WikiMacroParameterMacroParameters;
import org.xwiki.rendering.parser.Parser;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="wikimacroparameter")
@Singleton
public class WikiMacroParameterMacro
extends AbstractMacro<WikiMacroParameterMacroParameters> {
    public static final String ID = "wikimacroparameter";
    private static final String DESCRIPTION = "Display editable parameter of a wikimacro.";
    @Inject
    @Named(value="plain/1.0")
    private Parser plainTextParser;

    public WikiMacroParameterMacro() {
        super("WikiMacro Parameter", DESCRIPTION, (ContentDescriptor)new DefaultContentDescriptor(false), WikiMacroParameterMacroParameters.class);
        this.setDefaultCategories(Set.of("Development"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(WikiMacroParameterMacroParameters parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        LinkedHashMap<String, String> placeholderParameters = new LinkedHashMap<String, String>();
        placeholderParameters.put("data-wikimacro-id", ID);
        placeholderParameters.put("name", parameters.getName());
        if (context.isInline()) {
            return Collections.singletonList(new FormatBlock(Collections.emptyList(), Format.NONE, placeholderParameters));
        }
        return Collections.singletonList(new GroupBlock(placeholderParameters));
    }

    public boolean isExecutionIsolated(WikiMacroParameterMacroParameters parameters, String content) {
        return true;
    }
}

