/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.doc.AbstractMandatoryClassInitializer;
import com.xpn.xwiki.objects.classes.BaseClass;
import java.util.Arrays;
import javax.inject.Named;
import javax.inject.Singleton;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.rendering.wikimacro.internal.WikiMacroConstants;

@Component
@Named(value="XWiki.WikiMacroParameterClass")
@Singleton
public class WikiMacroParameterClassDocumentInitializer
extends AbstractMandatoryClassInitializer
implements WikiMacroConstants {
    private static final String PROPERTY_PIPE = "|";
    private static final String PROPERTY_YESNO = "yesno";

    public WikiMacroParameterClassDocumentInitializer() {
        super((EntityReference)WIKI_MACRO_PARAMETER_CLASS_REFERENCE);
    }

    protected void createClass(BaseClass xclass) {
        xclass.addTextField("name", "Parameter name", 30);
        xclass.addTextAreaField("description", "Parameter description", 40, 5);
        xclass.addBooleanField("mandatory", "Parameter mandatory", PROPERTY_YESNO);
        xclass.addTextField("defaultValue", "Parameter default value", 30);
        xclass.addStaticListField("type", "Parameter type", 1, false, false, StringUtils.join(Arrays.asList("Unknown", "Wiki"), (String)PROPERTY_PIPE), "input", PROPERTY_PIPE, "Unknown", "allowed", true);
        xclass.addTextField("feature", "Parameter feature", 30);
        xclass.addStaticListField("group", "Parameter group property", 1, true, false, null, "input", PROPERTY_PIPE, null, "allowed", false);
        xclass.addBooleanField("hidden", "Parameter hidden", PROPERTY_YESNO);
        xclass.addBooleanField("advanced", "Parameter advanced", PROPERTY_YESNO);
        xclass.addBooleanField("deprecated", "Parameter deprecated", PROPERTY_YESNO);
        xclass.addBooleanField("featureMandatory", "Parameter feature mandatory", PROPERTY_YESNO);
    }
}

