/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.FormatBlock;
import org.xwiki.rendering.block.GroupBlock;
import org.xwiki.rendering.listener.Format;
import org.xwiki.rendering.macro.AbstractNoParameterMacro;
import org.xwiki.rendering.macro.MacroExecutionException;
import org.xwiki.rendering.transformation.MacroTransformationContext;

@Component
@Named(value="wikimacrocontent")
@Singleton
public class WikiMacroContentMacro
extends AbstractNoParameterMacro {
    public static final String ID = "wikimacrocontent";
    private static final String DESCRIPTION = "Display editable content of a wikimacro.";

    public WikiMacroContentMacro() {
        super("WikiMacro Content", DESCRIPTION);
        this.setDefaultCategories(Set.of("Development"));
    }

    public boolean supportsInlineMode() {
        return true;
    }

    public List<Block> execute(Object parameters, String content, MacroTransformationContext context) throws MacroExecutionException {
        LinkedHashMap<String, String> placeholderParameters = new LinkedHashMap<String, String>();
        placeholderParameters.put("data-wikimacro-id", ID);
        if (context.isInline()) {
            return Collections.singletonList(new FormatBlock(Collections.emptyList(), Format.NONE, placeholderParameters));
        }
        return Collections.singletonList(new GroupBlock(placeholderParameters));
    }

    public boolean isExecutionIsolated(Object parameters, String content) {
        return true;
    }
}

