/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.internal.event.XARImportedEvent;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.observation.EventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.rendering.macro.wikibridge.WikiMacroInitializer;

@Component
@Singleton
@Named(value="register-macros-on-import")
public class RegisterMacrosOnImportListener
implements EventListener {
    @Inject
    private WikiMacroInitializer macroInitializer;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    private final List<Event> eventsList = new ArrayList<XARImportedEvent>(Arrays.asList(new XARImportedEvent()));

    public List<Event> getEvents() {
        return this.eventsList;
    }

    public String getName() {
        return "RegisterMacrosOnImportListener";
    }

    public void onEvent(Event event, Object source, Object data) {
        try {
            XWikiContext xcontext = (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
            xcontext.remove((Object)"grouplist");
            String currentWiki = xcontext.getWikiId();
            this.macroInitializer.registerExistingWikiMacros(currentWiki);
        }
        catch (Exception e) {
            this.logger.warn("Could not register existing macros on import", (Throwable)e);
        }
    }
}

