/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.rendering.wikimacro.internal;

import com.xpn.xwiki.XWikiContext;
import com.xpn.xwiki.doc.MandatoryDocumentInitializer;
import com.xpn.xwiki.doc.XWikiDocument;
import java.util.HashSet;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.SpaceReferenceResolver;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.query.Query;
import org.xwiki.query.QueryManager;
import org.xwiki.rendering.macro.wikibridge.InsufficientPrivilegesException;
import org.xwiki.rendering.macro.wikibridge.WikiMacro;
import org.xwiki.rendering.macro.wikibridge.WikiMacroException;
import org.xwiki.rendering.macro.wikibridge.WikiMacroFactory;
import org.xwiki.rendering.macro.wikibridge.WikiMacroInitializer;
import org.xwiki.rendering.macro.wikibridge.WikiMacroManager;
import org.xwiki.rendering.wikimacro.internal.WikiMacroConstants;

@Component
@Singleton
public class DefaultWikiMacroInitializer
implements WikiMacroInitializer,
WikiMacroConstants {
    @Inject
    private WikiMacroFactory wikiMacroFactory;
    @Inject
    private WikiMacroManager wikiMacroManager;
    @Inject
    private Execution execution;
    @Inject
    @Named(value="XWiki.WikiMacroClass")
    private MandatoryDocumentInitializer wikiMacroInitializer;
    @Inject
    @Named(value="XWiki.WikiMacroParameterClass")
    private MandatoryDocumentInitializer wikiMacroParameterInitializer;
    @Inject
    private Logger logger;
    @Inject
    private SpaceReferenceResolver<String> spaceReferenceResolver;

    private XWikiContext getContext() {
        return (XWikiContext)this.execution.getContext().getProperty("xwikicontext");
    }

    public void registerExistingWikiMacros() throws Exception {
        this.registerExistingWikiMacros(false, null);
    }

    public void registerExistingWikiMacros(String wiki) throws Exception {
        this.registerExistingWikiMacros(true, wiki);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerExistingWikiMacros(boolean local, String wiki) throws Exception {
        XWikiContext xcontext = this.getContext();
        String originalWiki = xcontext.getWikiId();
        try {
            if (!local) {
                HashSet wikiNames = new HashSet();
                wikiNames.addAll(xcontext.getWiki().getVirtualWikisDatabaseNames(xcontext));
                for (String wikiName : wikiNames) {
                    this.registerMacrosForWiki(wikiName, xcontext);
                }
            } else {
                this.registerMacrosForWiki(wiki, xcontext);
            }
        }
        finally {
            xcontext.setWikiId(originalWiki);
        }
    }

    private void registerMacrosForWiki(String wikiName, XWikiContext xcontext) {
        try {
            this.logger.debug("Registering all wiki macros found in wiki [{}]", (Object)wikiName);
            xcontext.setWikiId(wikiName);
            this.installOrUpgradeWikiMacroClasses();
            for (Object[] wikiMacroDocumentData : this.getWikiMacroDocumentData(xcontext)) {
                SpaceReference spaceReference = this.spaceReferenceResolver.resolve((Object)((String)wikiMacroDocumentData[0]), new Object[]{new WikiReference(wikiName)});
                DocumentReference wikiMacroDocumentReference = new DocumentReference((String)wikiMacroDocumentData[1], spaceReference);
                this.registerMacro(wikiMacroDocumentReference, (String)wikiMacroDocumentData[2], xcontext);
            }
        }
        catch (Exception ex) {
            this.logger.warn("Failed to register macros for wiki [{}]: {}", (Object)wikiName, (Object)ex.getMessage());
        }
    }

    private List<Object[]> getWikiMacroDocumentData(XWikiContext xcontext) throws Exception {
        QueryManager qm = xcontext.getWiki().getStore().getQueryManager();
        Query q = qm.getNamedQuery("getWikiMacroDocuments");
        return q.execute();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void registerMacro(DocumentReference wikiMacroDocumentReference, String wikiMacroDocumentAuthor, XWikiContext xcontext) {
        this.logger.debug("Registering macro in document [{}]...", (Object)wikiMacroDocumentReference);
        DocumentReference originalAuthor = xcontext.getUserReference();
        try {
            WikiMacro macro = this.wikiMacroFactory.createWikiMacro(wikiMacroDocumentReference);
            if (macro != null) {
                this.wikiMacroManager.registerWikiMacro(wikiMacroDocumentReference, macro);
                this.logger.debug("Macro [{}] from document [{}] is now registered.", (Object)macro.getDescriptor().getId().getId(), (Object)wikiMacroDocumentReference);
            } else {
                this.logger.debug("Macro from document [{}] cannot be registered because its id is null.", (Object)wikiMacroDocumentReference);
            }
        }
        catch (InsufficientPrivilegesException ex) {
            this.logger.debug(ex.getMessage(), (Throwable)ex);
        }
        catch (WikiMacroException ex) {
            this.logger.error(ex.getMessage(), (Throwable)ex);
        }
        finally {
            xcontext.setUserReference(originalAuthor);
        }
    }

    public void installOrUpgradeWikiMacroClasses() throws Exception {
        XWikiContext xcontext = this.getContext();
        XWikiDocument doc = xcontext.getWiki().getDocument(this.wikiMacroInitializer.getDocumentReference(), xcontext);
        if (this.wikiMacroInitializer.updateDocument(doc)) {
            this.update(doc);
        }
        if (this.wikiMacroParameterInitializer.updateDocument(doc = xcontext.getWiki().getDocument("XWiki.WikiMacroParameterClass", xcontext))) {
            this.update(doc);
        }
    }

    private void update(XWikiDocument doc) throws Exception {
        XWikiContext xcontext = this.getContext();
        if (doc.isNew()) {
            doc.setParent("XWiki.WebHome");
        }
        xcontext.getWiki().saveDocument(doc, xcontext);
    }
}

