/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.splitter.criterion.naming;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import javax.inject.Named;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.refactoring.internal.RefactoringUtils;
import org.xwiki.refactoring.splitter.criterion.naming.AbstractNamingCriterion;
import org.xwiki.refactoring.splitter.criterion.naming.NamingCriterion;
import org.xwiki.refactoring.splitter.criterion.naming.PageIndexNamingCriterion;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.BlockFilter;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.SpaceBlock;
import org.xwiki.rendering.block.SpecialSymbolBlock;
import org.xwiki.rendering.block.WordBlock;
import org.xwiki.rendering.block.XDOM;
import org.xwiki.rendering.renderer.BlockRenderer;
import org.xwiki.rendering.renderer.printer.DefaultWikiPrinter;
import org.xwiki.rendering.renderer.printer.WikiPrinter;

@Component
@Named(value="headingNames")
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class HeadingNameNamingCriterion
extends AbstractNamingCriterion {
    public static final String PARAM_PREPEND_BASE_PAGE_NAME = "prependBasePageName";
    @Inject
    @Named(value="plain/1.0")
    private BlockRenderer plainTextRenderer;
    @Inject
    @Named(value="mainPageNameAndNumbering")
    private NamingCriterion mainPageNameAndNumberingNamingCriterion;
    private final List<DocumentReference> documentReferences = new ArrayList<DocumentReference>();

    @Deprecated
    public HeadingNameNamingCriterion(String baseDocumentName, DocumentAccessBridge docBridge, BlockRenderer plainTextRenderer, boolean prependBasePageName) {
        this.getParameters().setBaseDocumentReference(RefactoringUtils.resolveDocumentReference(baseDocumentName, new Object[0]));
        this.getParameters().setParameter(PARAM_PREPEND_BASE_PAGE_NAME, prependBasePageName);
        this.docBridge = docBridge;
        this.plainTextRenderer = plainTextRenderer;
        this.mainPageNameAndNumberingNamingCriterion = new PageIndexNamingCriterion(baseDocumentName, docBridge);
    }

    public HeadingNameNamingCriterion() {
    }

    @Override
    public DocumentReference getDocumentReference(XDOM xdom) {
        DocumentReference documentReference;
        DocumentReference newDocumentReference = documentReference = this.maybeTruncate(this.computeDocumentReference(xdom));
        int localIndex = 0;
        while (this.documentReferences.contains(newDocumentReference) || this.exists(newDocumentReference)) {
            newDocumentReference = this.newDocumentReference(this.getPageName(documentReference) + "-" + ++localIndex);
        }
        this.documentReferences.add(newDocumentReference);
        return newDocumentReference;
    }

    private Optional<String> getFirstHeadingName(XDOM xdom) {
        Block firstChild;
        if (xdom.getChildren().size() > 0 && (firstChild = (Block)xdom.getChildren().get(0)) instanceof HeaderBlock) {
            Block clonedHeaderBlock = firstChild.clone(new BlockFilter(){

                public List<Block> filter(Block block) {
                    ArrayList<Block> blocks = new ArrayList<Block>();
                    if (block instanceof WordBlock || block instanceof SpaceBlock || block instanceof SpecialSymbolBlock) {
                        blocks.add(block);
                    }
                    return blocks;
                }
            });
            XDOM heading = new XDOM(clonedHeaderBlock.getChildren());
            DefaultWikiPrinter printer = new DefaultWikiPrinter();
            this.plainTextRenderer.render((Block)heading, (WikiPrinter)printer);
            String headingName = this.cleanPageName(printer.toString());
            return StringUtils.isEmpty((CharSequence)headingName) ? Optional.empty() : Optional.of(headingName);
        }
        return Optional.empty();
    }

    private DocumentReference computeDocumentReference(XDOM xdom) {
        Optional<String> documentName = this.getFirstHeadingName(xdom);
        if (documentName.isEmpty()) {
            this.mainPageNameAndNumberingNamingCriterion.getParameters().setBaseDocumentReference(this.getParameters().getBaseDocumentReference());
            this.mainPageNameAndNumberingNamingCriterion.getParameters().setUseTerminalPages(this.getParameters().isUseTerminalPages());
            return this.mainPageNameAndNumberingNamingCriterion.getDocumentReference(xdom);
        }
        if (this.getParameters().getParameter(PARAM_PREPEND_BASE_PAGE_NAME, false).booleanValue()) {
            return this.newDocumentReference(this.getBasePageName() + "-" + documentName.get());
        }
        return this.newDocumentReference(documentName.get());
    }

    private DocumentReference maybeTruncate(DocumentReference documentReference) {
        int maxLength = this.documentReferences.contains(documentReference) || this.exists(documentReference) ? 765 : 768;
        boolean isNotTerminal = "WebHome".equals(documentReference.getName());
        int lengthWithoutPageName = (isNotTerminal ? new DocumentReference(documentReference.getName(), new SpaceReference("n", documentReference.getLastSpaceReference().getParent())) : new DocumentReference("t", documentReference.getLastSpaceReference())).toString().length() - 1;
        if (lengthWithoutPageName < maxLength) {
            int maxPageNameLength = maxLength - lengthWithoutPageName;
            String pageName = this.getPageName(documentReference);
            if (pageName.length() > maxPageNameLength) {
                pageName = pageName.substring(0, maxPageNameLength);
                if (isNotTerminal) {
                    return new DocumentReference(documentReference.getName(), new SpaceReference(pageName, documentReference.getLastSpaceReference().getParent()));
                }
                return new DocumentReference(pageName, documentReference.getLastSpaceReference());
            }
        }
        return documentReference;
    }

    private String cleanPageName(String originalName) {
        String replaced = originalName.trim().replaceAll("[\\.:]", "-");
        replaced = replaced.replaceAll("[@?#~/]", "");
        return replaced;
    }
}

