/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.splitter.criterion.naming;

import javax.inject.Inject;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.refactoring.splitter.criterion.naming.NamingCriterion;
import org.xwiki.refactoring.splitter.criterion.naming.NamingCriterionParameters;

public abstract class AbstractNamingCriterion
implements NamingCriterion {
    private static final String DEFAULT_DOCUMENT_NAME = "WebHome";
    @Inject
    protected Logger logger;
    @Inject
    protected DocumentAccessBridge docBridge;
    private final NamingCriterionParameters parameters = new NamingCriterionParameters();

    @Override
    public NamingCriterionParameters getParameters() {
        return this.parameters;
    }

    protected boolean exists(DocumentReference documentReference) {
        try {
            return this.docBridge.exists(documentReference);
        }
        catch (Exception e) {
            this.logger.warn("Failed to check the existence of the document with reference [{}]. Root cause is [{}].", (Object)documentReference, (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            return false;
        }
    }

    protected String getBasePageName() {
        return this.getPageName(this.parameters.getBaseDocumentReference());
    }

    protected String getPageName(DocumentReference documentReference) {
        return DEFAULT_DOCUMENT_NAME.equals(documentReference.getName()) ? documentReference.getLastSpaceReference().getName() : documentReference.getName();
    }

    protected DocumentReference newDocumentReference(String pageName) {
        DocumentReference baseDocumentReference = this.parameters.getBaseDocumentReference();
        if (this.parameters.isUseTerminalPages()) {
            return new DocumentReference(pageName, baseDocumentReference.getLastSpaceReference());
        }
        return new DocumentReference(DEFAULT_DOCUMENT_NAME, new SpaceReference(pageName, baseDocumentReference.getLastSpaceReference()));
    }
}

