/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.splitter.criterion;

import java.util.Arrays;
import org.xwiki.refactoring.splitter.criterion.SplittingCriterion;
import org.xwiki.rendering.block.Block;
import org.xwiki.rendering.block.HeaderBlock;
import org.xwiki.rendering.block.SectionBlock;

public class HeadingLevelSplittingCriterion
implements SplittingCriterion {
    private int[] headingLevels;

    public HeadingLevelSplittingCriterion(int[] headingLevels) {
        this.headingLevels = headingLevels;
        Arrays.sort(this.headingLevels);
    }

    @Override
    public boolean shouldIterate(Block block, int depth) {
        return block instanceof SectionBlock && depth < this.headingLevels[this.headingLevels.length - 1];
    }

    @Override
    public boolean shouldSplit(Block block, int depth) {
        boolean shouldSplit = false;
        if (block instanceof SectionBlock) {
            SectionBlock section = (SectionBlock)block;
            Block firstChild = (Block)section.getChildren().get(0);
            shouldSplit = firstChild instanceof HeaderBlock && Arrays.binarySearch(this.headingLevels, depth) >= 0;
        }
        return shouldSplit;
    }
}

