/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.script;

import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.context.Execution;
import org.xwiki.job.Job;
import org.xwiki.job.JobException;
import org.xwiki.job.JobExecutor;
import org.xwiki.job.Request;
import org.xwiki.job.api.AbstractCheckRightsRequest;
import org.xwiki.model.EntityType;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.refactoring.RefactoringConfiguration;
import org.xwiki.refactoring.job.CopyRequest;
import org.xwiki.refactoring.job.CreateRequest;
import org.xwiki.refactoring.job.EntityRequest;
import org.xwiki.refactoring.job.MoveRequest;
import org.xwiki.refactoring.job.PermanentlyDeleteRequest;
import org.xwiki.refactoring.job.ReplaceUserRequest;
import org.xwiki.refactoring.job.RestoreRequest;
import org.xwiki.refactoring.script.RefactoringScriptServiceAspect;
import org.xwiki.refactoring.script.RequestFactory;
import org.xwiki.script.service.ScriptService;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="refactoring")
@Singleton
public class RefactoringScriptService
implements ScriptService {
    private static final String REFACTORING_ERROR_KEY = String.format("scriptservice.%s.error", "refactoring");
    @Inject
    private Execution execution;
    @Inject
    private JobExecutor jobExecutor;
    @Inject
    private RefactoringConfiguration configuration;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;
    @Inject
    private RequestFactory requestFactory;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private ModelContext modelContext;

    public RefactoringScriptService() {
        RefactoringScriptServiceAspect.ajc$interFieldInit$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$modelContext(this);
    }

    public RequestFactory getRequestFactory() {
        return this.requestFactory;
    }

    public Job move(MoveRequest request) {
        return this.execute("refactoring/move", request);
    }

    public Job move(Collection<EntityReference> sources, EntityReference destination) {
        return this.move(this.getRequestFactory().createMoveRequest(sources, destination));
    }

    public Job move(EntityReference source, EntityReference destination) {
        return this.move(this.getRequestFactory().createMoveRequest(source, destination));
    }

    public Job rename(MoveRequest request) {
        return this.execute("refactoring/rename", request);
    }

    public Job rename(EntityReference oldReference, EntityReference newReference) {
        return this.rename(this.getRequestFactory().createRenameRequest(oldReference, newReference));
    }

    public Job rename(EntityReference reference, String newName) {
        return this.rename(this.getRequestFactory().createRenameRequest(reference, newName));
    }

    public Job convertToNestedDocument(DocumentReference documentReference) {
        String defaultDocName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        if (!documentReference.getName().equals(defaultDocName)) {
            SpaceReference spaceReference = new SpaceReference(documentReference.getName(), documentReference.getParent());
            return this.rename((EntityReference)documentReference, (EntityReference)new DocumentReference(defaultDocName, spaceReference));
        }
        return null;
    }

    public Job convertToTerminalDocument(DocumentReference documentReference) {
        EntityReference parentReference;
        if (documentReference.getName().equals(this.defaultEntityReferenceProvider.getDefaultReference(documentReference.getType()).getName()) && (parentReference = documentReference.getParent()).getParent().getType() == EntityType.SPACE) {
            DocumentReference terminalDocumentReference = new DocumentReference(parentReference.getName(), new SpaceReference(parentReference.getParent()));
            return this.rename((EntityReference)documentReference, (EntityReference)terminalDocumentReference);
        }
        return null;
    }

    public Job copy(CopyRequest request) {
        return this.execute("refactoring/copy", request);
    }

    public Job copy(Collection<EntityReference> sources, EntityReference destination) {
        return this.copy(this.getRequestFactory().createCopyRequest(sources, destination));
    }

    public Job copy(EntityReference source, EntityReference destination) {
        return this.copy(this.getRequestFactory().createCopyRequest(source, destination));
    }

    public Job copyAs(CopyRequest request) {
        return this.execute("refactoring/copyAs", request);
    }

    public Job copyAs(EntityReference sourceReference, EntityReference copyReference) {
        return this.copyAs(this.getRequestFactory().createCopyAsRequest(sourceReference, copyReference));
    }

    public Job copyAs(EntityReference reference, String copyName) {
        return this.copyAs(this.getRequestFactory().createCopyAsRequest(reference, copyName));
    }

    public Job delete(EntityRequest request) {
        return this.execute("refactoring/delete", request);
    }

    public Job delete(Collection<EntityReference> entityReferences) {
        return this.delete(this.getRequestFactory().createDeleteRequest(entityReferences));
    }

    public Job delete(EntityReference entityReference) {
        return this.delete(Arrays.asList(entityReference));
    }

    public Job create(CreateRequest request) {
        return this.execute("refactoring/create", request);
    }

    public Job create(Collection<EntityReference> entityReferences) {
        return this.create(this.getRequestFactory().createCreateRequest(entityReferences));
    }

    public Job create(EntityReference entityReference) {
        return this.create(Arrays.asList(entityReference));
    }

    private Job execute(String type, AbstractCheckRightsRequest request) {
        this.setError(null);
        if (!this.authorization.hasAccess(Right.PROGRAM)) {
            request.setCheckRights(true);
            request.setUserReference(this.documentAccessBridge.getCurrentUserReference());
            request.setAuthorReference(this.documentAccessBridge.getCurrentAuthorReference());
        }
        try {
            return this.jobExecutor.execute(type, (Request)request);
        }
        catch (JobException e) {
            this.setError((Exception)((Object)e));
            return null;
        }
    }

    public Exception getLastError() {
        return (Exception)this.execution.getContext().getProperty(REFACTORING_ERROR_KEY);
    }

    private void setError(Exception e) {
        this.execution.getContext().setProperty(REFACTORING_ERROR_KEY, (Object)e);
    }

    public Job restore(RestoreRequest restoreRequest) {
        return this.execute("refactoring/restore", restoreRequest);
    }

    public Job restore(String batchId) {
        return this.restore(this.getRequestFactory().createRestoreRequest(batchId));
    }

    public Job restore(List<Long> deletedDocumentIds) {
        return this.restore(this.getRequestFactory().createRestoreRequest(deletedDocumentIds));
    }

    public Job permanentlyDelete(PermanentlyDeleteRequest request) {
        return this.execute("refactoring/permanentlyDelete", request);
    }

    public Job permanentlyDelete(String batchId) {
        return this.permanentlyDelete(this.getRequestFactory().createPermanentlyDeleteRequest(batchId));
    }

    public Job permanentlyDelete(List<Long> deletedDocumentIds) {
        return this.permanentlyDelete(this.getRequestFactory().createPermanentlyDeleteRequest(deletedDocumentIds));
    }

    public Job changeDocumentAuthor(DocumentReference oldAuthorReference, DocumentReference newAuthorReference) {
        ReplaceUserRequest request = this.getRequestFactory().createReplaceUserRequest(oldAuthorReference, newAuthorReference);
        request.setReplaceDocumentAuthor(true);
        request.setReplaceDocumentContentAuthor(true);
        return this.replaceUser(request);
    }

    public Job replaceUser(ReplaceUserRequest request) {
        return this.execute("refactoring/replaceUser", request);
    }

    public boolean isRecycleBinSkippingAllowed() {
        return this.configuration.isRecycleBinSkippingActivated() && this.documentAccessBridge.isAdvancedUser();
    }

    public static /* synthetic */ ModelContext ajc$get$modelContext(RefactoringScriptService refactoringScriptService) {
        return refactoringScriptService.modelContext;
    }

    public static /* synthetic */ void ajc$set$modelContext(RefactoringScriptService refactoringScriptService, ModelContext modelContext) {
        refactoringScriptService.modelContext = modelContext;
    }

    public /* synthetic */ Job ajc$privMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$execute(String string, AbstractCheckRightsRequest abstractCheckRightsRequest) {
        return this.execute(string, abstractCheckRightsRequest);
    }

    public static /* synthetic */ DocumentAccessBridge ajc$get$documentAccessBridge(RefactoringScriptService refactoringScriptService) {
        return refactoringScriptService.documentAccessBridge;
    }

    public static /* synthetic */ void ajc$set$documentAccessBridge(RefactoringScriptService refactoringScriptService, DocumentAccessBridge documentAccessBridge) {
        refactoringScriptService.documentAccessBridge = documentAccessBridge;
    }

    public /* synthetic */ MoveRequest ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$createMoveRequest(String string, Collection<EntityReference> collection, EntityReference entityReference) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createMoveRequest(this, string, collection, entityReference);
    }

    public /* synthetic */ List<String> ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$generateJobId(String string) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$generateJobId(this, string);
    }

    public /* synthetic */ WikiReference ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$getCurrentWikiReference() {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$getCurrentWikiReference(this);
    }

    public /* synthetic */ List<String> ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$getJobId(String string, String string2) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$getJobId(this, string, string2);
    }

    public /* synthetic */ void ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$initEntityRequest(EntityRequest entityRequest, String string, Collection<EntityReference> collection) {
        RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$initEntityRequest(this, entityRequest, string, collection);
    }

    public /* synthetic */ PermanentlyDeleteRequest ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$initializePermanentlyDeleteRequest() {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$initializePermanentlyDeleteRequest(this);
    }

    public /* synthetic */ RestoreRequest ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$initializeRestoreRequest() {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$initializeRestoreRequest(this);
    }

    public /* synthetic */ void ajc$interMethodDispatch2$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$setRightsProperties(AbstractCheckRightsRequest abstractCheckRightsRequest) {
        RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$setRightsProperties(this, abstractCheckRightsRequest);
    }

    @Deprecated
    public Job copy(MoveRequest moveRequest) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$copy(this, moveRequest);
    }

    @Deprecated
    public Job copyAs(MoveRequest moveRequest) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$copyAs(this, moveRequest);
    }

    @Deprecated
    public MoveRequest createCopyAsRequest(EntityReference entityReference, String string) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createCopyAsRequest(this, entityReference, string);
    }

    @Deprecated
    public MoveRequest createCopyAsRequest(EntityReference entityReference, EntityReference entityReference2) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createCopyAsRequest(this, entityReference, entityReference2);
    }

    @Deprecated
    public MoveRequest createCopyRequest(Collection<EntityReference> collection, EntityReference entityReference) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createCopyRequest(this, collection, entityReference);
    }

    @Deprecated
    public MoveRequest createCopyRequest(EntityReference entityReference, EntityReference entityReference2) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createCopyRequest(this, entityReference, entityReference2);
    }

    @Deprecated
    public CreateRequest createCreateRequest(Collection<EntityReference> collection) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createCreateRequest(this, collection);
    }

    @Deprecated
    public EntityRequest createDeleteRequest(Collection<EntityReference> collection) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createDeleteRequest(this, collection);
    }

    @Deprecated
    public MoveRequest createMoveRequest(Collection<EntityReference> collection, EntityReference entityReference) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createMoveRequest(this, collection, entityReference);
    }

    @Deprecated
    public MoveRequest createMoveRequest(EntityReference entityReference, EntityReference entityReference2) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createMoveRequest(this, entityReference, entityReference2);
    }

    @Deprecated
    public PermanentlyDeleteRequest createPermanentlyDeleteRequest(String string) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createPermanentlyDeleteRequest(this, string);
    }

    @Deprecated
    public PermanentlyDeleteRequest createPermanentlyDeleteRequest(List<Long> list) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createPermanentlyDeleteRequest(this, list);
    }

    @Deprecated
    public MoveRequest createRenameRequest(EntityReference entityReference, String string) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createRenameRequest(this, entityReference, string);
    }

    @Deprecated
    public MoveRequest createRenameRequest(EntityReference entityReference, EntityReference entityReference2) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createRenameRequest(this, entityReference, entityReference2);
    }

    @Deprecated
    public RestoreRequest createRestoreRequest(String string) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createRestoreRequest(this, string);
    }

    @Deprecated
    public RestoreRequest createRestoreRequest(List<Long> list) {
        return RefactoringScriptServiceAspect.ajc$interMethod$org_xwiki_refactoring_script_RefactoringScriptServiceAspect$org_xwiki_refactoring_script_RefactoringScriptService$createRestoreRequest(this, list);
    }
}

