/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.job.question;

import java.util.Optional;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.apache.commons.lang3.builder.ToStringBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.stability.Unstable;

public class EntitySelection
implements Comparable<EntitySelection> {
    private final EntityReference sourceEntityReference;
    private final EntityReference targetEntityReference;
    private State isSelected = State.UNKNOWN;

    public EntitySelection(EntityReference entityReference) {
        this(entityReference, null);
    }

    @Unstable
    public EntitySelection(EntityReference sourceEntityReference, EntityReference targetEntityReference) {
        this.sourceEntityReference = sourceEntityReference;
        this.targetEntityReference = targetEntityReference;
    }

    public EntityReference getEntityReference() {
        return this.sourceEntityReference;
    }

    @Unstable
    public Optional<EntityReference> getTargetEntityReference() {
        return this.targetEntityReference != null ? Optional.of(this.targetEntityReference) : Optional.empty();
    }

    public boolean isSelected() {
        return this.isSelected == State.UNKNOWN || this.isSelected == State.SELECTED;
    }

    public State getState() {
        return this.isSelected;
    }

    public void setSelected(boolean selected) {
        this.isSelected = selected ? State.SELECTED : State.DESELECTED;
    }

    public int hashCode() {
        return new HashCodeBuilder(3, 13).append((Object)this.getEntityReference()).append(this.getTargetEntityReference()).append((Object)this.isSelected).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        EntitySelection entitySelection = (EntitySelection)object;
        return new EqualsBuilder().append((Object)this.getEntityReference(), (Object)entitySelection.getEntityReference()).append(this.getTargetEntityReference(), entitySelection.getTargetEntityReference()).append(this.isSelected(), entitySelection.isSelected()).isEquals();
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("sourceEntityReference", (Object)this.sourceEntityReference).append("targetEntityReference", (Object)this.targetEntityReference).append("isSelected", (Object)this.isSelected).toString();
    }

    @Override
    public int compareTo(EntitySelection entitySelection) {
        if (entitySelection == null) {
            throw new NullPointerException("Provided entitySelection should not be null.");
        }
        if (entitySelection == this) {
            return 0;
        }
        if (this.sourceEntityReference == null) {
            return -1;
        }
        if (entitySelection.sourceEntityReference == null) {
            return 1;
        }
        int result = this.sourceEntityReference.compareTo(entitySelection.sourceEntityReference);
        if (result == 0) {
            return this.isSelected.compareTo(entitySelection.isSelected);
        }
        return result;
    }

    public static enum State {
        SELECTED,
        DESELECTED,
        UNKNOWN;

    }
}

