/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.script;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.stream.Collectors;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.apache.commons.lang3.Strings;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.bridge.DocumentAccessBridge;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.api.AbstractCheckRightsRequest;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.refactoring.job.CopyRequest;
import org.xwiki.refactoring.job.CreateRequest;
import org.xwiki.refactoring.job.DeleteRequest;
import org.xwiki.refactoring.job.EntityRequest;
import org.xwiki.refactoring.job.MoveRequest;
import org.xwiki.refactoring.job.PermanentlyDeleteRequest;
import org.xwiki.refactoring.job.ReplaceUserRequest;
import org.xwiki.refactoring.job.RestoreRequest;
import org.xwiki.refactoring.script.RequestFactory;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;
import org.xwiki.wiki.manager.WikiManagerException;

@Component
@Singleton
public class DefaultRequestFactory
implements RequestFactory {
    @Inject
    private Logger logger;
    @Inject
    private DocumentAccessBridge documentAccessBridge;
    @Inject
    private WikiDescriptorManager wikiDescriptorManager;

    private List<String> generateJobId(String type) {
        String suffix = new Date().getTime() + "-" + ThreadLocalRandom.current().nextInt(100, 1000);
        return this.getJobId(type, suffix);
    }

    private List<String> getJobId(String type, String suffix) {
        return Arrays.asList("refactoring", Strings.CS.removeStart(type, (CharSequence)"refactoring/"), suffix);
    }

    private void setRightsProperties(AbstractCheckRightsRequest request) {
        request.setCheckRights(true);
        request.setUserReference(this.documentAccessBridge.getCurrentUserReference());
        request.setAuthorReference(this.documentAccessBridge.getCurrentAuthorReference());
    }

    @Override
    public MoveRequest createMoveRequest(Collection<EntityReference> sources, EntityReference destination) {
        return this.createMoveRequest("refactoring/move", sources, destination);
    }

    @Override
    public MoveRequest createMoveRequest(EntityReference source, EntityReference destination) {
        return this.createMoveRequest(Arrays.asList(source), destination);
    }

    @Override
    public MoveRequest createRenameRequest(EntityReference oldReference, EntityReference newReference) {
        return this.createMoveRequest("refactoring/rename", Collections.singletonList(oldReference), newReference);
    }

    @Override
    public MoveRequest createRenameRequest(EntityReference reference, String newName) {
        return this.createRenameRequest(reference, new EntityReference(newName, reference.getType(), reference.getParent()));
    }

    @Override
    public CopyRequest createCopyRequest(Collection<EntityReference> sources, EntityReference destination) {
        EntityReference dest;
        CopyRequest request = new CopyRequest();
        this.initEntityRequest(request, "refactoring/copy", sources);
        if (destination.getType().equals((Object)EntityType.DOCUMENT)) {
            DocumentReference documentReference = new DocumentReference(destination);
            dest = documentReference.getLastSpaceReference();
        } else {
            dest = destination;
        }
        request.setDestination(dest);
        return request;
    }

    @Override
    public CopyRequest createCopyRequest(EntityReference source, EntityReference destination) {
        return this.createCopyRequest(Arrays.asList(source), destination);
    }

    @Override
    public CopyRequest createCopyAsRequest(EntityReference sourceReference, EntityReference copyReference) {
        CopyRequest request = new CopyRequest();
        this.initEntityRequest(request, "refactoring/copyAs", Arrays.asList(sourceReference));
        request.setDestination(copyReference);
        return request;
    }

    @Override
    public CopyRequest createCopyAsRequest(EntityReference reference, String copyName) {
        EntityReference copyReference = new EntityReference(copyName, reference.getType(), reference.getParent());
        return this.createCopyAsRequest(reference, copyReference);
    }

    @Override
    public EntityRequest createDeleteRequest(Collection<EntityReference> entityReferences) {
        DeleteRequest request = new DeleteRequest();
        this.initEntityRequest(request, "refactoring/delete", entityReferences);
        return request;
    }

    @Override
    public CreateRequest createCreateRequest(Collection<EntityReference> entityReferences) {
        CreateRequest request = new CreateRequest();
        this.initEntityRequest(request, "refactoring/create", entityReferences);
        request.setDeep(true);
        return request;
    }

    private void initEntityRequest(EntityRequest request, String type, Collection<EntityReference> entityReferences) {
        request.setId(this.generateJobId(type));
        request.setJobType(type);
        request.setEntityReferences(entityReferences);
        this.setRightsProperties(request);
    }

    private MoveRequest createMoveRequest(String type, Collection<EntityReference> sources, EntityReference destination) {
        MoveRequest request = new MoveRequest();
        this.initEntityRequest(request, type, sources);
        request.setDestination(destination);
        request.setUpdateLinks(true);
        request.setAutoRedirect(true);
        request.setUpdateParentField(true);
        return request;
    }

    @Override
    public PermanentlyDeleteRequest createPermanentlyDeleteRequest(String batchId) {
        PermanentlyDeleteRequest request = this.initializePermanentlyDeleteRequest();
        request.setBatchId(batchId);
        return request;
    }

    @Override
    public PermanentlyDeleteRequest createPermanentlyDeleteRequest(List<Long> deletedDocumentIds) {
        PermanentlyDeleteRequest request = this.initializePermanentlyDeleteRequest();
        request.setDeletedDocumentIds(deletedDocumentIds);
        return request;
    }

    private PermanentlyDeleteRequest initializePermanentlyDeleteRequest() {
        PermanentlyDeleteRequest request = new PermanentlyDeleteRequest();
        request.setId(this.generateJobId("refactoring/permanentlyDelete"));
        request.setCheckRights(true);
        request.setUserReference(this.documentAccessBridge.getCurrentUserReference());
        request.setWikiReference(this.getCurrentWikiReference());
        return request;
    }

    @Override
    public RestoreRequest createRestoreRequest(String batchId) {
        RestoreRequest request = this.initializeRestoreRequest();
        request.setBatchId(batchId);
        return request;
    }

    @Override
    public RestoreRequest createRestoreRequest(List<Long> deletedDocumentIds) {
        RestoreRequest request = this.initializeRestoreRequest();
        request.setDeletedDocumentIds(deletedDocumentIds);
        return request;
    }

    private RestoreRequest initializeRestoreRequest() {
        RestoreRequest request = new RestoreRequest();
        request.setId(this.generateJobId("refactoring/restore"));
        request.setCheckRights(true);
        request.setUserReference(this.documentAccessBridge.getCurrentUserReference());
        request.setWikiReference(this.getCurrentWikiReference());
        return request;
    }

    private WikiReference getCurrentWikiReference() {
        String currentWikiId = this.wikiDescriptorManager.getCurrentWikiId();
        return currentWikiId != null ? new WikiReference(currentWikiId) : null;
    }

    @Override
    public ReplaceUserRequest createReplaceUserRequest(DocumentReference oldUserReference, DocumentReference newUserReference) {
        ReplaceUserRequest request = new ReplaceUserRequest();
        request.setId(this.generateJobId("refactoring/replaceUser"));
        request.setOldUserReference(oldUserReference);
        request.setNewUserReference(newUserReference);
        this.setRightsProperties(request);
        Collection<String> targetWikis = null;
        if (oldUserReference != null) {
            targetWikis = this.getReplaceUserTargetWikis(oldUserReference);
        } else if (newUserReference != null) {
            targetWikis = this.getReplaceUserTargetWikis(newUserReference);
        }
        if (targetWikis != null) {
            request.setEntityReferences(targetWikis.stream().map(WikiReference::new).collect(Collectors.toSet()));
        }
        return request;
    }

    private Collection<String> getReplaceUserTargetWikis(DocumentReference userReference) {
        if (userReference.getWikiReference().getName().equals(this.wikiDescriptorManager.getMainWikiId())) {
            try {
                return this.wikiDescriptorManager.getAllIds();
            }
            catch (WikiManagerException e) {
                this.logger.warn("Failed to get the list of wikis. Root cause is [{}].", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                return Collections.emptySet();
            }
        }
        return Collections.singleton(userReference.getWikiReference().getName());
    }
}

