/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.listener;

import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentLifecycleException;
import org.xwiki.component.phase.Disposable;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.job.Job;
import org.xwiki.job.JobContext;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.job.event.status.JobStatus;
import org.xwiki.link.LinkStore;
import org.xwiki.refactoring.RefactoringException;
import org.xwiki.refactoring.internal.job.AbstractEntityJob;
import org.xwiki.refactoring.internal.listener.LinkIndexingQuestionHandler;
import org.xwiki.refactoring.job.EntityRequest;
import org.xwiki.store.ReadyIndicator;

@Component(roles={LinkIndexingWaitingHelper.class})
@Singleton
public class LinkIndexingWaitingHelper
implements Initializable,
Disposable {
    private ExecutorService executor;
    @Inject
    private JobContext jobContext;
    @Inject
    private JobProgressManager progressManager;
    @Inject
    private Provider<LinkStore> linkStore;
    @Inject
    private Logger logger;

    public void initialize() throws InitializationException {
        this.executor = Executors.newCachedThreadPool();
    }

    public void dispose() throws ComponentLifecycleException {
        this.executor.shutdown();
    }

    public void maybeWaitForLinkIndexingWithLog(int timeout, TimeUnit timeUnit) {
        AbstractEntityJob entityJob;
        Job currentJob = this.jobContext.getCurrentJob();
        if (currentJob != null && (!(currentJob instanceof AbstractEntityJob) || ((EntityRequest)(entityJob = (AbstractEntityJob)currentJob).getRequest()).isWaitForIndexing())) {
            try {
                this.logger.info("Waiting for the link index to be updated.");
                this.waitWithQuestion(timeout, timeUnit);
                this.logger.info("Finished waiting for the link index");
            }
            catch (InterruptedException e) {
                this.logger.warn("Interrupted while waiting for link indexing: [{}], continuing nevertheless.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.logger.debug("Full interrupted exception:", (Throwable)e);
                Thread.currentThread().interrupt();
            }
            catch (RefactoringException e) {
                this.logger.warn("Failed to wait for the link index to be updated: [{}], continuing nevertheless.", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
                this.logger.debug("Full exception:", (Throwable)e);
            }
        }
    }

    public void waitWithQuestion(int timeout, TimeUnit unit) throws InterruptedException, RefactoringException {
        if (this.jobContext.getCurrentJob() == null) {
            throw new IllegalStateException("This method must be used inside a job.");
        }
        this.progressManager.pushLevelProgress(100, (Object)this);
        ReadyIndicator readyIndicator = ((LinkStore)this.linkStore.get()).waitReady();
        try {
            this.waitOnReadyIndicatorWithProgress(readyIndicator, timeout, unit);
        }
        catch (ExecutionException e) {
            throw new RefactoringException("Error while waiting for the link index to be updated.", e.getCause());
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void waitOnReadyIndicatorWithProgress(ReadyIndicator readyIndicator, int timeout, TimeUnit unit) throws ExecutionException, InterruptedException {
        block7: {
            int percent = 0;
            JobStatus jobStatus = this.jobContext.getCurrentJob().getStatus();
            LinkIndexingQuestionHandler questionHandler = new LinkIndexingQuestionHandler(timeout, unit, () -> ((ReadyIndicator)readyIndicator).getProgressPercentage(), jobStatus, this.executor);
            while (true) {
                try {
                    readyIndicator.get(1L, TimeUnit.SECONDS);
                    return;
                }
                catch (TimeoutException e) {
                    while (percent < readyIndicator.getProgressPercentage()) {
                        this.progressManager.startStep((Object)this);
                        ++percent;
                    }
                    if (questionHandler.shallContinueWaiting()) continue;
                    this.logger.info("Not waiting for the link index to be updated anymore as the user asked to stop waiting.");
                    break block7;
                }
                break;
            }
            finally {
                questionHandler.cancelPendingQuestion();
            }
        }
    }
}

