/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.listener;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.internal.ModelBridge;
import org.xwiki.refactoring.job.MoveRequest;

@Component
@Named(value="refactoring.legacyParentFieldUpdater")
@Singleton
public class LegacyParentFieldUpdaterListener
extends AbstractLocalEventListener {
    public static final String NAME = "refactoring.legacyParentFieldUpdater";
    @Inject
    private Logger logger;
    @Inject
    private ModelBridge modelBridge;

    public LegacyParentFieldUpdaterListener() {
        super(NAME, new Event[]{new DocumentRenamedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        boolean updateParentField = true;
        if (data instanceof MoveRequest) {
            updateParentField = ((MoveRequest)((Object)data)).isUpdateParentField();
        }
        if (updateParentField) {
            DocumentRenamedEvent documentRenamedEvent = (DocumentRenamedEvent)event;
            this.logger.info("Updating the document parent fields from [{}] to [{}].", documentRenamedEvent.getSourceReference(), documentRenamedEvent.getTargetReference());
            this.modelBridge.updateParentField((DocumentReference)documentRenamedEvent.getSourceReference(), (DocumentReference)documentRenamedEvent.getTargetReference());
        }
    }
}

