/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.listener;

import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Provider;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.bridge.event.DocumentDeletedEvent;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.JobContext;
import org.xwiki.job.event.status.JobProgressManager;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.RefactoringException;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.internal.ModelBridge;
import org.xwiki.refactoring.internal.ReferenceUpdater;
import org.xwiki.refactoring.internal.job.DeleteJob;
import org.xwiki.refactoring.internal.job.MoveJob;
import org.xwiki.refactoring.internal.listener.LinkIndexingWaitingHelper;
import org.xwiki.refactoring.job.DeleteRequest;
import org.xwiki.refactoring.job.MoveRequest;
import org.xwiki.security.authorization.ContextualAuthorizationManager;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="refactoring.backLinksUpdater")
@Singleton
public class BackLinkUpdaterListener
extends AbstractLocalEventListener {
    public static final String NAME = "refactoring.backLinksUpdater";
    @Inject
    private Logger logger;
    @Inject
    private ReferenceUpdater updater;
    @Inject
    private ModelBridge modelBridge;
    @Inject
    private ContextualAuthorizationManager authorization;
    @Inject
    private JobProgressManager progressManager;
    @Inject
    private JobContext jobContext;
    @Inject
    private Provider<LinkIndexingWaitingHelper> linkIndexingHelper;

    public BackLinkUpdaterListener() {
        super(NAME, new Event[]{new DocumentRenamedEvent(), new DocumentDeletedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        try {
            if (event instanceof DocumentRenamedEvent) {
                this.maybeUpdateLinksAfterRename(event, source, data);
            } else if (event instanceof DocumentDeletedEvent && this.jobContext.getCurrentJob() instanceof DeleteJob) {
                this.maybeUpdateLinksAfterDelete(event);
            }
        }
        catch (RefactoringException e) {
            this.logger.error("Failed to update links backlinks", (Throwable)e);
        }
    }

    private void maybeUpdateLinksAfterDelete(Event event) throws RefactoringException {
        DeleteJob job = (DeleteJob)this.jobContext.getCurrentJob();
        DeleteRequest request = (DeleteRequest)job.getRequest();
        Predicate<EntityReference> canEdit = entityReference -> job.hasAccess(Right.EDIT, (EntityReference)entityReference);
        DocumentDeletedEvent deletedEvent = (DocumentDeletedEvent)event;
        DocumentReference newTarget = request.getNewBacklinkTargets().get(deletedEvent.getDocumentReference());
        if (request.isUpdateLinks() && newTarget != null) {
            this.updateBackLinks(deletedEvent.getDocumentReference(), newTarget, canEdit, Map.of());
        }
    }

    private void maybeUpdateLinksAfterRename(Event event, Object source, Object data) throws RefactoringException {
        boolean updateLinks = true;
        Predicate<EntityReference> canEdit = entityReference -> this.authorization.hasAccess(Right.EDIT, entityReference);
        Map<EntityReference, EntityReference> updatedEntities = Map.of();
        if (source instanceof MoveJob) {
            MoveRequest request = (MoveRequest)((Object)data);
            updateLinks = request.isUpdateLinks();
            canEdit = entityReference -> ((MoveJob)((Object)((Object)source))).hasAccess(Right.EDIT, (EntityReference)entityReference);
            updatedEntities = ((MoveJob)((Object)source)).getSelectedEntities();
        }
        if (updateLinks) {
            DocumentRenamedEvent renameEvent = (DocumentRenamedEvent)event;
            this.updateBackLinks((DocumentReference)renameEvent.getSourceReference(), (DocumentReference)renameEvent.getTargetReference(), canEdit, updatedEntities);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateBackLinks(DocumentReference source, DocumentReference target, Predicate<EntityReference> canEdit, Map<EntityReference, EntityReference> updatedEntities) throws RefactoringException {
        this.logger.info("Updating the back-links for document [{}].", (Object)source);
        ((LinkIndexingWaitingHelper)this.linkIndexingHelper.get()).maybeWaitForLinkIndexingWithLog(10, TimeUnit.SECONDS);
        Set<DocumentReference> backlinkDocumentReferences = this.modelBridge.getBackLinkedDocuments((EntityReference)source);
        this.progressManager.pushLevelProgress(backlinkDocumentReferences.size(), (Object)this);
        try {
            for (DocumentReference backlinkDocumentReference : backlinkDocumentReferences) {
                this.progressManager.startStep((Object)this);
                if (canEdit.test((EntityReference)backlinkDocumentReference)) {
                    this.updater.update(backlinkDocumentReference, (EntityReference)source, (EntityReference)target, updatedEntities);
                }
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }
}

