/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.listener;

import javax.inject.Inject;
import javax.inject.Named;
import javax.inject.Singleton;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.event.AbstractLocalEventListener;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.internal.ModelBridge;
import org.xwiki.refactoring.job.MoveRequest;

@Component
@Named(value="refactoring.automaticRedirectCreator")
@Singleton
public class AutomaticRedirectCreatorListener
extends AbstractLocalEventListener {
    public static final String NAME = "refactoring.automaticRedirectCreator";
    private static final String CREATING_AUTOMATIC_REDIRECT_FROM_TO = "Creating automatic redirect from [{}] to [{}].";
    @Inject
    private Logger logger;
    @Inject
    private ModelBridge modelBridge;

    public AutomaticRedirectCreatorListener() {
        super(NAME, new Event[]{new DocumentRenamedEvent()});
    }

    public void processLocalEvent(Event event, Object source, Object data) {
        if (event instanceof DocumentRenamedEvent) {
            DocumentRenamedEvent documentRenamedEvent = (DocumentRenamedEvent)event;
            boolean autoRedirect = true;
            if (data instanceof MoveRequest) {
                MoveRequest moveRequest = (MoveRequest)((Object)data);
                autoRedirect = moveRequest.isAutoRedirect();
            }
            if (autoRedirect) {
                this.logger.info(CREATING_AUTOMATIC_REDIRECT_FROM_TO, documentRenamedEvent.getSourceReference(), documentRenamedEvent.getTargetReference());
                this.modelBridge.createRedirect((DocumentReference)documentRenamedEvent.getSourceReference(), (DocumentReference)documentRenamedEvent.getTargetReference());
            }
        }
    }
}

