/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.List;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.api.AbstractCheckRightsRequest;
import org.xwiki.refactoring.internal.job.AbstractDeletedDocumentsJob;

@Component
@Named(value="refactoring/permanentlyDelete")
public class PermanentlyDeleteJob
extends AbstractDeletedDocumentsJob {
    public String getType() {
        return "refactoring/permanentlyDelete";
    }

    @Override
    protected void handleDeletedDocuments(List<Long> idsDeletedDocuments, AbstractCheckRightsRequest request) {
        if (idsDeletedDocuments.isEmpty()) {
            this.modelBridge.permanentlyDeleteAllDocuments(this, request);
        } else {
            this.handleDeleteSomeDocumentsFromRecycleBin(idsDeletedDocuments, request);
        }
    }

    private void handleDeleteSomeDocumentsFromRecycleBin(List<Long> idsDeletedDocuments, AbstractCheckRightsRequest request) {
        this.progressManager.pushLevelProgress(idsDeletedDocuments.size(), (Object)this);
        for (Long idToDelete : idsDeletedDocuments) {
            if (((AbstractJobStatus)this.status).isCanceled()) break;
            this.progressManager.startStep((Object)this);
            this.modelBridge.permanentlyDeleteDocument(idToDelete, request);
            this.progressManager.endStep((Object)this);
        }
        this.progressManager.popLevelProgress((Object)this);
    }
}

