/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.Collection;
import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.EndFoldEvent;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.event.DocumentRenamingEvent;
import org.xwiki.refactoring.event.EntitiesRenamedEvent;
import org.xwiki.refactoring.event.EntitiesRenamingEvent;
import org.xwiki.refactoring.internal.job.AbstractCopyOrMoveJob;
import org.xwiki.refactoring.job.MoveRequest;
import org.xwiki.security.authorization.Right;

@Component
@Named(value="refactoring/move")
public class MoveJob
extends AbstractCopyOrMoveJob<MoveRequest> {
    public String getType() {
        return "refactoring/move";
    }

    @Override
    protected BeginFoldEvent createBeginEvent() {
        return new EntitiesRenamingEvent();
    }

    @Override
    protected EndFoldEvent createEndEvent() {
        return new EntitiesRenamedEvent();
    }

    @Override
    protected void getEntities(Collection<EntityReference> entityReferences) {
        super.getEntities(entityReferences);
        this.notifyDocumentsDeleting();
    }

    @Override
    protected boolean checkAllRights(DocumentReference oldReference, DocumentReference newReference) throws Exception {
        boolean isWebPreferences = this.isSpacePreferencesReference((EntityReference)oldReference) && this.isSpacePreferencesReference((EntityReference)newReference);
        DocumentReference oldHomeReference = this.getSpaceHomeReference(oldReference);
        if (isWebPreferences && this.concernedEntities.containsKey(oldHomeReference)) {
            if (!this.hasAccess(Right.DELETE, (EntityReference)oldHomeReference)) {
                this.logger.error("You don't have sufficient permissions over the home document of WebPreferences [{}].", (Object)newReference);
                return false;
            }
            return super.checkAllRights(oldReference, newReference);
        }
        if (!this.hasAccess(Right.DELETE, (EntityReference)oldReference)) {
            this.logger.error("You are not allowed to delete [{}].", (Object)oldReference);
            return false;
        }
        return super.checkAllRights(oldReference, newReference);
    }

    @Override
    protected void performRefactoring(DocumentReference oldReference, DocumentReference newReference) {
        DocumentRenamingEvent documentRenamingEvent = new DocumentRenamingEvent(oldReference, newReference);
        DocumentRenamedEvent documentRenamedEvent = new DocumentRenamedEvent(oldReference, newReference);
        try {
            this.copyOrMove(oldReference, newReference, documentRenamingEvent, documentRenamedEvent);
        }
        catch (Exception e) {
            this.logger.error("Failed to copy or move document from [{}] to [{}]", new Object[]{oldReference, newReference, e});
        }
    }

    @Override
    protected boolean atomicOperation(DocumentReference source, DocumentReference target) {
        return this.modelBridge.rename(source, target);
    }
}

