/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import javax.inject.Named;
import org.xwiki.component.annotation.Component;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.EndFoldEvent;
import org.xwiki.refactoring.event.DocumentCopiedEvent;
import org.xwiki.refactoring.event.DocumentCopyingEvent;
import org.xwiki.refactoring.event.EntitiesCopiedEvent;
import org.xwiki.refactoring.event.EntitiesCopyingEvent;
import org.xwiki.refactoring.internal.job.AbstractCopyOrMoveJob;
import org.xwiki.refactoring.job.CopyRequest;

@Component
@Named(value="refactoring/copy")
public class CopyJob
extends AbstractCopyOrMoveJob<CopyRequest> {
    public String getType() {
        return "refactoring/copy";
    }

    @Override
    protected void performRefactoring(DocumentReference sourceReference, DocumentReference targetReference) {
        DocumentCopyingEvent documentCopyingEvent = new DocumentCopyingEvent(sourceReference, targetReference);
        DocumentCopiedEvent documentCopiedEvent = new DocumentCopiedEvent(sourceReference, targetReference);
        try {
            this.copyOrMove(sourceReference, targetReference, documentCopyingEvent, documentCopiedEvent);
        }
        catch (Exception e) {
            this.logger.error("Failed to copy or move document from [{}] to [{}]", new Object[]{sourceReference, targetReference, e});
        }
    }

    @Override
    protected boolean atomicOperation(DocumentReference source, DocumentReference target) {
        return this.modelBridge.copy(source, target);
    }

    @Override
    protected BeginFoldEvent createBeginEvent() {
        return new EntitiesCopyingEvent();
    }

    @Override
    protected EndFoldEvent createEndEvent() {
        return new EntitiesCopiedEvent();
    }
}

