/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.Collection;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.xwiki.bridge.event.DocumentsDeletingEvent;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.internal.job.AbstractEntityJob;
import org.xwiki.refactoring.job.EntityJobStatus;
import org.xwiki.refactoring.job.EntityRequest;
import org.xwiki.refactoring.job.question.EntitySelection;

public abstract class AbstractEntityJobWithChecks<R extends EntityRequest, S extends EntityJobStatus<? super R>>
extends AbstractEntityJob<R, S> {
    protected final Map<EntityReference, EntitySelection> concernedEntities = new HashMap<EntityReference, EntitySelection>();

    @Override
    protected void runInternal() throws Exception {
        this.progressManager.pushLevelProgress(2, (Object)this);
        try {
            Collection<EntityReference> entityReferences = ((EntityRequest)this.request).getEntityReferences();
            if (entityReferences != null) {
                this.progressManager.startStep((Object)this);
                this.getEntities(entityReferences);
                this.progressManager.startStep((Object)this);
                this.setContextUser();
                this.process(entityReferences);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    public Map<EntityReference, EntityReference> getSelectedEntities() {
        return this.concernedEntities.values().stream().filter(EntitySelection::isSelected).filter(entity -> entity.getTargetEntityReference().isPresent()).collect(Collectors.toMap(EntitySelection::getEntityReference, entity -> entity.getTargetEntityReference().get()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void getEntities(Collection<EntityReference> entityReferences) {
        this.progressManager.pushLevelProgress(entityReferences.size(), (Object)this);
        try {
            for (EntityReference entityReference : entityReferences) {
                if (((EntityJobStatus)this.status).isCanceled()) {
                    break;
                }
                this.progressManager.startStep((Object)this);
                this.getEntities(entityReference);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected void getEntities(EntityReference entityReference) {
        switch (entityReference.getType()) {
            case DOCUMENT: {
                this.getEntities(new DocumentReference(entityReference));
                break;
            }
            case SPACE: {
                this.getEntities(new SpaceReference(entityReference));
                break;
            }
            default: {
                this.logger.error("Unsupported entity type [{}].", (Object)entityReference.getType());
            }
        }
    }

    protected DocumentReference cleanLocale(DocumentReference documentReference) {
        if (Locale.ROOT.equals(documentReference.getLocale())) {
            return new DocumentReference((EntityReference)documentReference, (Locale)null);
        }
        return documentReference;
    }

    protected void putInConcernedEntities(DocumentReference documentReference) {
        DocumentReference cleanDocumentReference = this.cleanLocale(documentReference);
        this.concernedEntities.put((EntityReference)cleanDocumentReference, new EntitySelection((EntityReference)cleanDocumentReference));
    }

    protected void getEntities(DocumentReference documentReference) {
        if (((EntityRequest)this.request).isDeep() && this.isSpaceHomeReference(documentReference)) {
            this.getEntities(documentReference.getLastSpaceReference());
        } else {
            this.putInConcernedEntities(documentReference);
        }
    }

    protected void getEntities(SpaceReference spaceReference) {
        this.visitDocuments(spaceReference, this::putInConcernedEntities);
    }

    protected void notifyDocumentsDeleting() {
        DocumentsDeletingEvent event = new DocumentsDeletingEvent();
        this.observationManager.notify((Event)event, (Object)this, this.concernedEntities);
        if (event.isCanceled()) {
            ((EntityJobStatus)this.getStatus()).cancel();
        }
    }

    protected EntitySelection getConcernedEntitiesEntitySelection(EntityReference reference) {
        DocumentReference documentReference;
        EntitySelection entitySelection = this.concernedEntities.get(reference);
        if (entitySelection == null && reference instanceof DocumentReference && Locale.ROOT.equals((documentReference = (DocumentReference)reference).getLocale())) {
            entitySelection = this.concernedEntities.get(new DocumentReference((EntityReference)documentReference.withoutLocale(), (Locale)null));
        }
        return entitySelection;
    }
}

