/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.Collection;
import java.util.Iterator;
import javax.inject.Inject;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.EntityReferenceProvider;
import org.xwiki.model.reference.EntityReferenceTree;
import org.xwiki.model.reference.EntityReferenceTreeNode;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.refactoring.internal.ModelBridge;
import org.xwiki.refactoring.job.EntityJobStatus;
import org.xwiki.refactoring.job.EntityRequest;
import org.xwiki.security.authorization.AuthorizationManager;
import org.xwiki.security.authorization.Right;

public abstract class AbstractEntityJob<R extends EntityRequest, S extends EntityJobStatus<? super R>>
extends AbstractJob<R, S>
implements GroupedJob {
    protected static final String PREFERENCES_DOCUMENT_NAME = "WebPreferences";
    private static final JobGroupPath ROOT_GROUP = new JobGroupPath("refactoring", null);
    @Inject
    protected ModelBridge modelBridge;
    private JobGroupPath groupPath;
    @Inject
    private AuthorizationManager authorization;
    @Inject
    private EntityReferenceProvider defaultEntityReferenceProvider;

    public JobGroupPath getGroupPath() {
        return this.groupPath;
    }

    public void initialize(Request request) {
        super.initialize(request);
        EntityReference commonParent = this.getCommonParent();
        if (commonParent != null) {
            this.groupPath = ROOT_GROUP;
            for (EntityReference reference : commonParent.getReversedReferenceChain()) {
                this.groupPath = new JobGroupPath(reference.getName(), this.groupPath);
            }
        } else {
            this.groupPath = ROOT_GROUP;
        }
    }

    protected S createNewStatus(R request) {
        return (S)((Object)new EntityJobStatus<R>(this.getType(), request, this.observationManager, this.loggerManager, null));
    }

    protected EntityReference getCommonParent() {
        return this.getCommonParent(((EntityRequest)this.request).getEntityReferences());
    }

    protected EntityReference getCommonParent(Collection<EntityReference> entityReferences) {
        if (entityReferences == null || entityReferences.isEmpty()) {
            return null;
        }
        Iterator<EntityReference> iterator = entityReferences.iterator();
        EntityReference commonParent = iterator.next();
        while (iterator.hasNext()) {
            EntityReference entity = iterator.next();
            while (!entity.hasParent(commonParent)) {
                if ((commonParent = commonParent.getParent()) != null) continue;
                return null;
            }
        }
        return commonParent;
    }

    protected void runInternal() throws Exception {
        Collection<EntityReference> entityReferences = ((EntityRequest)this.request).getEntityReferences();
        if (entityReferences != null) {
            this.setContextUser();
            this.process(entityReferences);
        }
    }

    protected void setContextUser() {
        this.modelBridge.setContextUserReference(((EntityRequest)this.request).getUserReference());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void process(Collection<EntityReference> entityReferences) {
        this.progressManager.pushLevelProgress(entityReferences.size(), (Object)this);
        try {
            for (EntityReference entityReference : entityReferences) {
                if (((EntityJobStatus)this.status).isCanceled()) {
                    break;
                }
                this.progressManager.startStep((Object)this);
                this.process(entityReference);
                this.progressManager.endStep((Object)this);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    protected abstract void process(EntityReference var1);

    public boolean hasAccess(Right right, EntityReference reference) {
        return !(((EntityRequest)this.request).isCheckRights() && !this.authorization.hasAccess(right, ((EntityRequest)this.request).getUserReference(), reference) || ((EntityRequest)this.request).isCheckAuthorRights() && !this.authorization.hasAccess(right, ((EntityRequest)this.request).getAuthorReference(), reference));
    }

    protected boolean isSpaceHomeReference(DocumentReference documentReference) {
        return documentReference.getName().equals(this.defaultEntityReferenceProvider.getDefaultReference(documentReference.getType()).getName());
    }

    protected DocumentReference getSpaceHomeReference(DocumentReference reference) {
        String referenceName = this.defaultEntityReferenceProvider.getDefaultReference(EntityType.DOCUMENT).getName();
        return new DocumentReference(referenceName, reference.getLastSpaceReference());
    }

    protected boolean isSpacePreferencesReference(EntityReference entityReference) {
        return entityReference.getType() == EntityType.DOCUMENT && PREFERENCES_DOCUMENT_NAME.equals(entityReference.getName());
    }

    protected void visitDocuments(SpaceReference spaceReference, Visitor<DocumentReference> visitor) {
        this.visitDocumentNodes(this.getDocumentReferenceTree(spaceReference), visitor);
    }

    private EntityReferenceTreeNode getDocumentReferenceTree(SpaceReference spaceReference) {
        return new EntityReferenceTree(this.modelBridge.getDocumentReferences(spaceReference)).get((EntityReference)spaceReference);
    }

    private void visitDocumentNodes(EntityReferenceTreeNode node, Visitor<DocumentReference> visitor) {
        if (node != null) {
            EntityType nodeType;
            EntityReference nodeReference = node.getReference();
            EntityType entityType = nodeType = nodeReference != null ? nodeReference.getType() : null;
            if (nodeType == EntityType.SPACE || nodeType == EntityType.WIKI || nodeType == null) {
                this.visitDocumentAncestor(node, visitor);
            } else if (nodeType == EntityType.DOCUMENT) {
                visitor.visit((DocumentReference)node.getReference());
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void visitDocumentAncestor(EntityReferenceTreeNode node, Visitor<DocumentReference> visitor) {
        Collection children = node.getChildren();
        this.progressManager.pushLevelProgress(children.size(), (Object)this);
        try {
            EntityReferenceTreeNode spacePreferencesNode = null;
            for (EntityReferenceTreeNode child : children) {
                if (this.isSpacePreferencesReference(child.getReference())) {
                    spacePreferencesNode = child;
                    continue;
                }
                this.visitDocumentAncestorStep(child, visitor);
            }
            if (spacePreferencesNode != null) {
                this.visitDocumentAncestorStep(spacePreferencesNode, visitor);
            }
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private void visitDocumentAncestorStep(EntityReferenceTreeNode node, Visitor<DocumentReference> visitor) {
        this.progressManager.startStep((Object)this);
        if (!((EntityJobStatus)this.status).isCanceled()) {
            this.visitDocumentNodes(node, visitor);
        }
        this.progressManager.endStep((Object)this);
    }

    public static interface Visitor<T> {
        public void visit(T var1);
    }
}

