/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.ArrayList;
import java.util.List;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.job.AbstractJob;
import org.xwiki.job.AbstractJobStatus;
import org.xwiki.job.GroupedJob;
import org.xwiki.job.JobGroupPath;
import org.xwiki.job.Request;
import org.xwiki.job.api.AbstractCheckRightsRequest;
import org.xwiki.model.ModelContext;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.WikiReference;
import org.xwiki.refactoring.internal.ModelBridge;
import org.xwiki.refactoring.job.AbstractDeletedDocumentsRequest;

public abstract class AbstractDeletedDocumentsJob
extends AbstractJob<AbstractDeletedDocumentsRequest, AbstractJobStatus<AbstractDeletedDocumentsRequest>>
implements GroupedJob {
    static final JobGroupPath ROOT_GROUP = new JobGroupPath("refactoring", null);
    @Inject
    protected ModelBridge modelBridge;
    @Inject
    protected ModelContext modelContext;
    private JobGroupPath groupPath;

    protected AbstractJobStatus<AbstractDeletedDocumentsRequest> createNewStatus(AbstractDeletedDocumentsRequest request) {
        AbstractJobStatus status = (AbstractJobStatus)super.createNewStatus((Request)request);
        status.setCancelable(true);
        return status;
    }

    protected void runInternal() throws Exception {
        AbstractDeletedDocumentsRequest request = (AbstractDeletedDocumentsRequest)this.getRequest();
        this.initializeContext(request);
        this.progressManager.pushLevelProgress(2, (Object)this);
        this.progressManager.startStep((Object)this);
        List<Long> idsToRestore = this.getIdsToHandle(request);
        this.progressManager.startStep((Object)this);
        this.handleDeletedDocuments(idsToRestore, request);
        this.progressManager.popLevelProgress((Object)this);
    }

    protected abstract void handleDeletedDocuments(List<Long> var1, AbstractCheckRightsRequest var2);

    private void initializeContext(AbstractDeletedDocumentsRequest request) throws IllegalArgumentException {
        DocumentReference userReference = request.getUserReference();
        this.modelBridge.setContextUserReference(userReference);
        WikiReference wikiReference = request.getWikiReference();
        if (wikiReference == null) {
            throw new IllegalArgumentException("No wiki reference was specified in the job request");
        }
        this.modelContext.setCurrentEntityReference((EntityReference)wikiReference);
    }

    private List<Long> getIdsToHandle(AbstractDeletedDocumentsRequest request) {
        List<Long> deletedDocumentIds;
        ArrayList<Long> result = new ArrayList<Long>();
        String batchId = request.getBatchId();
        if (StringUtils.isNotBlank((CharSequence)batchId)) {
            List<Long> batchDeletedDocumentIds = this.modelBridge.getDeletedDocumentIds(batchId);
            result.addAll(batchDeletedDocumentIds);
        }
        if ((deletedDocumentIds = request.getDeletedDocumentIds()) != null) {
            for (long deletedDocumentId : deletedDocumentIds) {
                if (result.contains(deletedDocumentId)) continue;
                result.add(deletedDocumentId);
            }
        }
        return result;
    }

    public JobGroupPath getGroupPath() {
        return this.groupPath;
    }

    public void initialize(Request request) {
        super.initialize(request);
        WikiReference wikiReference = ((AbstractDeletedDocumentsRequest)request).getWikiReference();
        if (wikiReference != null) {
            this.groupPath = new JobGroupPath(wikiReference.getName(), ROOT_GROUP);
        }
    }
}

