/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.job;

import java.util.LinkedList;
import java.util.function.BiConsumer;
import org.xwiki.model.EntityType;
import org.xwiki.model.reference.DocumentReference;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.model.reference.SpaceReference;
import org.xwiki.observation.event.BeginFoldEvent;
import org.xwiki.observation.event.CancelableEvent;
import org.xwiki.observation.event.EndFoldEvent;
import org.xwiki.observation.event.Event;
import org.xwiki.refactoring.internal.event.AbstractEntityCopyOrRenameEvent;
import org.xwiki.refactoring.internal.job.AbstractEntityJobWithChecks;
import org.xwiki.refactoring.job.AbstractCopyOrMoveRequest;
import org.xwiki.refactoring.job.EntityJobStatus;
import org.xwiki.refactoring.job.OverwriteQuestion;
import org.xwiki.refactoring.job.question.EntitySelection;
import org.xwiki.security.authorization.Right;

public abstract class AbstractCopyOrMoveJob<T extends AbstractCopyOrMoveRequest>
extends AbstractEntityJobWithChecks<T, EntityJobStatus<T>> {
    private Boolean overwriteAll;

    @Override
    protected void runInternal() throws Exception {
        this.progressManager.pushLevelProgress(3, (Object)this);
        try {
            this.progressManager.startStep((Object)this);
            BeginFoldEvent beginEvent = this.createBeginEvent();
            this.observationManager.notify((Event)beginEvent, (Object)this, (Object)this.getRequest());
            if (beginEvent instanceof CancelableEvent && ((CancelableEvent)beginEvent).isCanceled()) {
                return;
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            if (((AbstractCopyOrMoveRequest)this.request).getDestination() != null) {
                super.runInternal();
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            EndFoldEvent endEvent = this.createEndEvent();
            this.observationManager.notify((Event)endEvent, (Object)this, (Object)this.getRequest());
            this.progressManager.endStep((Object)this);
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    @Override
    protected void getEntities(EntityReference entityReference) {
        EntityReference destination = ((AbstractCopyOrMoveRequest)this.request).getDestination();
        if (this.isSourceDestinationCompatible(entityReference, destination, true)) {
            super.getEntities(entityReference);
        }
    }

    protected boolean processOnlySameSourceDestinationTypes() {
        return false;
    }

    @Override
    protected void process(EntityReference source) {
        EntityReference destination = ((AbstractCopyOrMoveRequest)this.request).getDestination();
        if (!this.isSourceDestinationCompatible(source, destination, false)) {
            return;
        }
        switch (source.getType()) {
            case DOCUMENT: {
                try {
                    this.process(new DocumentReference(source), destination);
                }
                catch (Exception e) {
                    this.logger.error("Failed to copy or move document with reference [{}]", (Object)source, (Object)e);
                }
                break;
            }
            case SPACE: {
                this.visitSpace(new SpaceReference(source), destination, this::maybePerformRefactoring);
                break;
            }
            default: {
                this.logger.error("Unsupported source entity type [{}].", (Object)source.getType());
            }
        }
    }

    private boolean isSourceDestinationCompatible(EntityReference source, EntityReference destination, boolean log) {
        boolean result = true;
        if (this.processOnlySameSourceDestinationTypes() && source.getType() != destination.getType()) {
            if (log) {
                this.logger.error("You cannot change the entity type (from [{}] to [{}]).", (Object)source.getType(), (Object)destination.getType());
            }
            result = false;
        }
        if (this.isDescendantOrSelf(destination, source)) {
            if (log) {
                this.logger.error("Cannot make [{}] a descendant of itself.", (Object)source);
            }
            result = false;
        }
        if (source.getParent() != null && source.getParent().equals((Object)destination)) {
            if (log) {
                this.logger.error("Cannot move [{}] into [{}], it's already there.", (Object)source, (Object)destination);
            }
            result = false;
        }
        return result;
    }

    private boolean isDescendantOrSelf(EntityReference alice, EntityReference bob) {
        EntityReference parent;
        for (parent = alice; parent != null && !parent.equals((Object)bob); parent = parent.getParent()) {
        }
        return parent != null;
    }

    @Override
    protected void getEntities(DocumentReference documentReference) {
        this.putInConcernedEntities(documentReference);
    }

    @Override
    protected void putInConcernedEntities(DocumentReference documentReference) {
        DocumentReference source = this.cleanLocale(documentReference);
        EntityReference destination = ((AbstractCopyOrMoveRequest)this.request).getDestination();
        if (this.processOnlySameSourceDestinationTypes()) {
            this.putInConcernedEntitiesOnlySameSource(source, destination);
        } else if (((AbstractCopyOrMoveRequest)this.request).isDeep() && this.isSpaceHomeReference(source)) {
            this.visitSpace(source.getLastSpaceReference(), destination, this::putInConcernedEntities);
        } else if (destination.getType() == EntityType.SPACE) {
            DocumentReference destinationDocumentReference = new DocumentReference(source.getName(), new SpaceReference(destination));
            this.putInConcernedEntities(source, destinationDocumentReference);
        } else if (destination.getType() == EntityType.DOCUMENT && this.isSpaceHomeReference(new DocumentReference(destination))) {
            DocumentReference destinationDocumentReference = new DocumentReference(source.getName(), new SpaceReference(destination.getParent()));
            this.putInConcernedEntities(source, destinationDocumentReference);
        } else if (destination.getType() == EntityType.WIKI) {
            this.visitSpace(source.getLastSpaceReference(), destination, this::putInConcernedEntities);
        }
    }

    private void putInConcernedEntitiesOnlySameSource(DocumentReference source, EntityReference destination) {
        DocumentReference destinationDocumentReference = destination.getType() == EntityType.SPACE ? new DocumentReference(source.getName(), new SpaceReference(destination)) : new DocumentReference(destination);
        if (((AbstractCopyOrMoveRequest)this.request).isDeep() && this.isSpaceHomeReference(source)) {
            if (this.isSpaceHomeReference(destinationDocumentReference)) {
                this.visitSpace(source.getLastSpaceReference(), (EntityReference)destinationDocumentReference.getLastSpaceReference(), this::putInConcernedEntities);
            }
        } else {
            this.putInConcernedEntities(source, destinationDocumentReference);
        }
    }

    private void putInConcernedEntities(DocumentReference sourceDocument, DocumentReference destination) {
        try {
            if (!this.modelBridge.exists(sourceDocument)) {
                this.logger.warn("Skipping [{}] because it doesn't exist.", (Object)sourceDocument);
            } else if (this.checkAllRights(sourceDocument, destination)) {
                this.concernedEntities.put(sourceDocument, new EntitySelection((EntityReference)sourceDocument, (EntityReference)destination));
            }
        }
        catch (Exception e) {
            this.logger.error("Failed to perform the refactoring from document with reference [{}] to [{}]", new Object[]{sourceDocument, destination, e});
        }
    }

    protected void process(DocumentReference source, EntityReference destination) throws Exception {
        if (this.processOnlySameSourceDestinationTypes()) {
            DocumentReference destinationDocumentReference = new DocumentReference(destination);
            this.process(source, destinationDocumentReference);
        } else if (((AbstractCopyOrMoveRequest)this.request).isDeep() && this.isSpaceHomeReference(source)) {
            this.visitSpace(source.getLastSpaceReference(), destination, this::maybePerformRefactoring);
        } else if (destination.getType() == EntityType.SPACE) {
            this.maybePerformRefactoring(source, new DocumentReference(source.getName(), new SpaceReference(destination)));
        } else if (destination.getType() == EntityType.DOCUMENT && this.isSpaceHomeReference(new DocumentReference(destination))) {
            this.maybePerformRefactoring(source, new DocumentReference(source.getName(), new SpaceReference(destination.getParent())));
        } else {
            this.logger.error("Unsupported destination entity type [{}] for a document.", (Object)destination.getType());
        }
    }

    protected void process(DocumentReference source, DocumentReference destination) throws Exception {
        if (((AbstractCopyOrMoveRequest)this.request).isDeep() && this.isSpaceHomeReference(source)) {
            if (this.isSpaceHomeReference(destination)) {
                this.process(source.getLastSpaceReference(), destination.getLastSpaceReference());
            } else {
                this.logger.error("You cannot transform a non-terminal document [{}] into a terminal document [{}] and preserve its child documents at the same time.", (Object)source, (Object)destination);
            }
        } else {
            this.maybePerformRefactoring(source, destination);
        }
    }

    private void visitSpace(SpaceReference source, EntityReference destination, BiConsumer<DocumentReference, DocumentReference> callback) {
        SpaceReference spaceDestination;
        if (this.processOnlySameSourceDestinationTypes()) {
            spaceDestination = new SpaceReference(destination);
        } else if (destination.getType() == EntityType.SPACE || destination.getType() == EntityType.WIKI) {
            spaceDestination = new SpaceReference(source.getName(), destination);
        } else if (destination.getType() == EntityType.DOCUMENT && this.isSpaceHomeReference(new DocumentReference(destination))) {
            spaceDestination = new SpaceReference(source.getName(), destination.getParent());
        } else {
            spaceDestination = null;
            this.logger.error("Unsupported destination entity type [{}] for a space.", (Object)destination.getType());
        }
        if (spaceDestination != null) {
            this.visitDocuments(source, oldChildReference -> {
                DocumentReference newChildReference = oldChildReference.replaceParent((EntityReference)source, (EntityReference)spaceDestination);
                callback.accept((DocumentReference)oldChildReference, newChildReference);
            });
        }
    }

    protected void process(SpaceReference source, SpaceReference destination) {
        this.visitSpace(source, (EntityReference)destination, this::maybePerformRefactoring);
    }

    protected boolean checkAllRights(DocumentReference oldReference, DocumentReference newReference) throws Exception {
        boolean isWebPreferences = this.isSpacePreferencesReference((EntityReference)oldReference) && this.isSpacePreferencesReference((EntityReference)newReference);
        DocumentReference oldHomeReference = this.getSpaceHomeReference(oldReference);
        boolean result = true;
        if (!isWebPreferences || !this.concernedEntities.containsKey(oldHomeReference)) {
            if (!this.hasAccess(Right.VIEW, (EntityReference)oldReference)) {
                this.logger.error("You don't have sufficient permissions over the source document [{}].", (Object)oldReference);
                result = false;
            } else if (!this.hasAccess(Right.EDIT, (EntityReference)newReference) || this.modelBridge.exists(newReference) && !this.hasAccess(Right.DELETE, (EntityReference)newReference)) {
                this.logger.error("You don't have sufficient permissions over the destination document [{}].", (Object)newReference);
                result = false;
            }
        } else if (!this.hasAccess(Right.EDIT, (EntityReference)oldHomeReference)) {
            this.logger.error("You don't have sufficient permissions over the home document of WebPreferences [{}].", (Object)newReference);
            result = false;
        }
        return result;
    }

    protected void maybePerformRefactoring(DocumentReference oldReference, DocumentReference newReference) {
        EntitySelection entitySelection = this.getConcernedEntitiesEntitySelection((EntityReference)oldReference);
        if (entitySelection == null) {
            this.logger.info("Skipping [{}] because it does not match any entity selection.", (Object)oldReference);
        } else if (!entitySelection.isSelected()) {
            this.logger.info("Skipping [{}] because it has been unselected.", (Object)oldReference);
        } else {
            this.performRefactoring(oldReference, newReference);
        }
    }

    protected abstract void performRefactoring(DocumentReference var1, DocumentReference var2);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean copyOrMove(DocumentReference oldReference, DocumentReference newReference, AbstractEntityCopyOrRenameEvent<?> beforeEvent, AbstractEntityCopyOrRenameEvent<?> afterEvent) throws Exception {
        this.progressManager.pushLevelProgress(5, (Object)this);
        try {
            this.progressManager.startStep((Object)this);
            this.observationManager.notify(beforeEvent, (Object)this, (Object)this.getRequest());
            if (beforeEvent.isCanceled()) {
                boolean bl = false;
                return bl;
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            if (this.modelBridge.exists(newReference) && ((AbstractCopyOrMoveRequest)this.request).isInteractive() && !this.modelBridge.canOverwriteSilently(newReference) && !this.confirmOverwrite((EntityReference)oldReference, (EntityReference)newReference)) {
                this.logger.warn("Skipping [{}] because [{}] already exists and the user doesn't want to overwrite it.", (Object)oldReference, (Object)newReference);
                boolean bl = false;
                return bl;
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            if (!this.atomicOperation(oldReference, newReference)) {
                boolean bl = false;
                return bl;
            }
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            this.modelBridge.update(newReference, ((AbstractCopyOrMoveRequest)this.request).getEntityParameters((EntityReference)oldReference));
            this.progressManager.endStep((Object)this);
            this.progressManager.startStep((Object)this);
            this.observationManager.notify(afterEvent, (Object)this, (Object)this.getRequest());
            this.progressManager.endStep((Object)this);
            boolean bl = true;
            return bl;
        }
        finally {
            this.progressManager.popLevelProgress((Object)this);
        }
    }

    private boolean confirmOverwrite(EntityReference source, EntityReference destination) {
        if (this.overwriteAll == null) {
            OverwriteQuestion question = new OverwriteQuestion(source, destination);
            try {
                ((EntityJobStatus)this.status).ask(question);
                if (((EntityJobStatus)this.status).isCanceled()) {
                    return false;
                }
                if (!question.isAskAgain()) {
                    this.overwriteAll = question.isOverwrite();
                }
                return question.isOverwrite();
            }
            catch (InterruptedException e) {
                this.logger.warn("Overwrite question has been interrupted.");
                return false;
            }
        }
        return this.overwriteAll;
    }

    @Override
    protected EntityReference getCommonParent() {
        LinkedList<EntityReference> entityReferences = new LinkedList<EntityReference>(((AbstractCopyOrMoveRequest)this.request).getEntityReferences());
        entityReferences.add(((AbstractCopyOrMoveRequest)this.request).getDestination());
        return this.getCommonParent(entityReferences);
    }

    protected abstract boolean atomicOperation(DocumentReference var1, DocumentReference var2);

    protected abstract BeginFoldEvent createBeginEvent();

    protected abstract EndFoldEvent createEndEvent();
}

