/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.event;

import java.io.Serializable;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Set;
import javax.inject.Named;
import javax.inject.Singleton;
import org.xwiki.component.annotation.Component;
import org.xwiki.observation.event.Event;
import org.xwiki.observation.remote.LocalEventData;
import org.xwiki.observation.remote.RemoteEventData;
import org.xwiki.observation.remote.converter.AbstractEventConverter;
import org.xwiki.refactoring.event.DocumentCopiedEvent;
import org.xwiki.refactoring.event.DocumentCopyingEvent;
import org.xwiki.refactoring.event.DocumentRenamedEvent;
import org.xwiki.refactoring.event.DocumentRenamingEvent;

@Component
@Singleton
@Named(value="DocumentCopyOrMoveEvent")
public class DocumentCopyOrMoveEventConverter
extends AbstractEventConverter {
    private static final Set<Class<? extends Event>> EVENTS = new HashSet<Class>(Arrays.asList(DocumentRenamingEvent.class, DocumentRenamedEvent.class, DocumentCopyingEvent.class, DocumentCopiedEvent.class));

    public boolean toRemote(LocalEventData localEvent, RemoteEventData remoteEvent) {
        if (EVENTS.contains(localEvent.getEvent().getClass())) {
            remoteEvent.setEvent((Serializable)localEvent.getEvent());
            remoteEvent.setData((Serializable)localEvent.getData());
            return true;
        }
        return false;
    }

    public boolean fromRemote(RemoteEventData remoteEvent, LocalEventData localEvent) {
        if (EVENTS.contains(remoteEvent.getEvent().getClass())) {
            localEvent.setEvent((Event)remoteEvent.getEvent());
            localEvent.setData((Object)remoteEvent.getData());
            return true;
        }
        return false;
    }
}

