/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.event;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.EqualsBuilder;
import org.apache.commons.lang3.builder.HashCodeBuilder;
import org.xwiki.model.reference.EntityReference;
import org.xwiki.refactoring.internal.event.AbstractEvent;

public abstract class AbstractEntityCopyOrRenameEvent<T extends EntityReference>
extends AbstractEvent
implements Serializable {
    private static final long serialVersionUID = 1L;
    private final T sourceReference;
    private final T targetReference;

    public AbstractEntityCopyOrRenameEvent() {
        this(null, null);
    }

    public AbstractEntityCopyOrRenameEvent(T sourceReference, T targetReference) {
        this.sourceReference = sourceReference;
        this.targetReference = targetReference;
    }

    public T getSourceReference() {
        return this.sourceReference;
    }

    public T getTargetReference() {
        return this.targetReference;
    }

    public int hashCode() {
        return new HashCodeBuilder(7, 91).append(this.sourceReference).append(this.targetReference).toHashCode();
    }

    public boolean equals(Object object) {
        if (object == null) {
            return false;
        }
        if (object == this) {
            return true;
        }
        if (object.getClass() != this.getClass()) {
            return false;
        }
        AbstractEntityCopyOrRenameEvent event = (AbstractEntityCopyOrRenameEvent)object;
        return new EqualsBuilder().append(this.sourceReference, event.sourceReference).append(this.targetReference, event.targetReference).isEquals();
    }

    @Override
    public boolean matches(Object occuringEvent) {
        boolean matches = super.matches(occuringEvent);
        if (matches) {
            AbstractEntityCopyOrRenameEvent copyOrRenameEvent = (AbstractEntityCopyOrRenameEvent)occuringEvent;
            matches = AbstractEntityCopyOrRenameEvent.matches(this.sourceReference, copyOrRenameEvent.getSourceReference()) && AbstractEntityCopyOrRenameEvent.matches(this.targetReference, copyOrRenameEvent.getTargetReference());
        }
        return matches;
    }

    private static boolean matches(EntityReference expected, EntityReference actual) {
        return expected == null || expected.equals((Object)actual) || AbstractEntityCopyOrRenameEvent.hasParentOfSameType(actual, expected);
    }

    private static boolean hasParentOfSameType(EntityReference entityReference, EntityReference parentReference) {
        return entityReference != null && Objects.equals(entityReference.getType(), parentReference.getType()) && entityReference.hasParent(parentReference);
    }
}

