/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.refactoring.internal.batch;

import java.util.Objects;
import java.util.UUID;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.context.Execution;
import org.xwiki.refactoring.batch.BatchOperation;
import org.xwiki.refactoring.batch.BatchOperationExecutor;

@Component
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class DefaultBatchOperationExecutor
implements BatchOperationExecutor {
    static final String CONTEXT_PROPERTY = "BATCH_ID";
    @Inject
    private Execution execution;

    @Override
    public <E extends Exception> void execute(BatchOperation<E> operation) throws E {
        String batchId = this.generateBatchId();
        this.execute(operation, batchId);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public <E extends Exception> void execute(BatchOperation<E> operation, String batchId) throws E {
        boolean cleanBatchId = false;
        String batchIdToUse = this.getCurrentBatchId();
        if (StringUtils.isBlank((CharSequence)batchIdToUse)) {
            batchIdToUse = batchId;
            if (StringUtils.isBlank((CharSequence)batchIdToUse)) {
                batchIdToUse = this.generateBatchId();
            }
            this.execution.getContext().setProperty(CONTEXT_PROPERTY, (Object)batchIdToUse);
            cleanBatchId = true;
        }
        try {
            operation.execute();
        }
        finally {
            if (cleanBatchId) {
                this.execution.getContext().setProperty(CONTEXT_PROPERTY, null);
            }
        }
    }

    protected String generateBatchId() {
        String result = UUID.randomUUID().toString();
        return result;
    }

    @Override
    public String getCurrentBatchId() {
        Object existingBatchIdObject = this.execution.getContext().getProperty(CONTEXT_PROPERTY);
        String batchId = Objects.toString(existingBatchIdObject, null);
        return batchId;
    }
}

