/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.hibernate.internal;

import jakarta.inject.Named;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import javax.inject.Inject;
import javax.inject.Singleton;
import org.hibernate.HibernateException;
import org.hibernate.cfg.Configuration;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.descriptor.ComponentDescriptor;
import org.xwiki.component.manager.ComponentLookupException;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.extension.version.Version;
import org.xwiki.extension.version.internal.DefaultVersion;
import org.xwiki.store.hibernate.DatabaseProductNameResolver;
import org.xwiki.store.hibernate.HibernateAdapter;
import org.xwiki.store.hibernate.HibernateAdapterFactory;

@Component
@Singleton
@Named(value="id/version")
public class IDVersionHibernateAdapterFactory
implements HibernateAdapterFactory {
    private static final Version DEFAULT_VERSION = new DefaultVersion("0");
    @Inject
    private ComponentManager componentManager;
    @Inject
    private List<DatabaseProductNameResolver> resolvers;

    @Override
    public Optional<HibernateAdapter> createHibernateAdapter(DatabaseMetaData metaData, Configuration hibernateConfiguration) throws HibernateException {
        Map<Version, String> versions;
        HibernateAdapter adapter = null;
        Map<String, Map<Version, String>> mapping = this.getAdapterMapping();
        try {
            String databaseProductId = this.getDatabaseId(metaData.getDatabaseProductName());
            versions = mapping.get(databaseProductId);
        }
        catch (SQLException e) {
            throw new HibernateException("Failed to access the database product name", (Throwable)e);
        }
        if (versions != null) {
            DefaultVersion currentVersion;
            try {
                currentVersion = new DefaultVersion(metaData.getDatabaseProductVersion());
            }
            catch (SQLException e) {
                throw new HibernateException("Failed to access the database product version", (Throwable)e);
            }
            String roleHint = null;
            for (Map.Entry<Version, String> entry : versions.entrySet()) {
                if (entry.getKey().compareTo((Object)currentVersion) > 0) break;
                roleHint = entry.getValue();
            }
            if (roleHint != null) {
                try {
                    adapter = (HibernateAdapter)this.componentManager.getInstance(HibernateAdapter.class, roleHint);
                }
                catch (ComponentLookupException e) {
                    throw new HibernateException("Failed to initialize the adapater", (Throwable)e);
                }
            }
        }
        return Optional.ofNullable(adapter);
    }

    private String getDatabaseId(String databaseProductName) {
        for (DatabaseProductNameResolver resolver : this.resolvers) {
            Optional<String> id = resolver.resolve(databaseProductName);
            if (!id.isPresent()) continue;
            return id.get();
        }
        return databaseProductName.toLowerCase();
    }

    private Map<String, Map<Version, String>> getAdapterMapping() {
        List descriptors = this.componentManager.getComponentDescriptorList(HibernateAdapter.class);
        HashMap<String, Map<Version, String>> databases = new HashMap<String, Map<Version, String>>();
        for (ComponentDescriptor descriptor : descriptors) {
            String roleHint = descriptor.getRoleHint();
            if (roleHint == null || "default".equalsIgnoreCase(roleHint)) continue;
            String databaseName = roleHint;
            Version databaseVersion = DEFAULT_VERSION;
            int index = roleHint.indexOf("/");
            if (index > 0) {
                databaseName = roleHint.substring(0, index);
                if (roleHint.length() > index) {
                    databaseVersion = new DefaultVersion(roleHint.substring(index + 1));
                }
            }
            Map databaseVersions = databases.computeIfAbsent(databaseName.toLowerCase(), n -> new TreeMap());
            databaseVersions.put(databaseVersion, roleHint);
        }
        return databases;
    }
}

