/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.store.hibernate;

import com.xpn.xwiki.internal.store.hibernate.HibernateConfiguration;
import com.xpn.xwiki.internal.store.hibernate.HibernateStore;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.hibernate.HibernateException;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.boot.Metadata;
import org.hibernate.dialect.Dialect;
import org.hibernate.mapping.PersistentClass;
import org.hibernate.mapping.Table;
import org.hibernate.tool.hbm2ddl.SchemaUpdate;
import org.hibernate.tool.schema.TargetType;
import org.slf4j.Logger;
import org.xwiki.stability.Unstable;
import org.xwiki.store.hibernate.HibernateAdapter;
import org.xwiki.store.hibernate.HibernateStoreException;
import org.xwiki.wiki.descriptor.WikiDescriptorManager;

@Unstable
public abstract class AbstractHibernateAdapter
implements HibernateAdapter {
    private static final String VIRTUAL_MODE_SCHEMA = "schema";
    @Inject
    protected WikiDescriptorManager wikis;
    @Inject
    protected Logger logger;
    @Inject
    private HibernateStore hibernateStore;
    @Inject
    private HibernateConfiguration hibernateConfiguration;

    @Override
    public boolean isConfiguredInSchemaMode() {
        String virtualModePropertyValue = this.hibernateStore.getConfiguration().getProperty("xwiki.virtual_mode");
        if (virtualModePropertyValue == null) {
            virtualModePropertyValue = VIRTUAL_MODE_SCHEMA;
        }
        return StringUtils.equals((CharSequence)virtualModePropertyValue, (CharSequence)VIRTUAL_MODE_SCHEMA);
    }

    @Override
    public String getDatabaseFromWikiName() {
        return this.getDatabaseFromWikiName(this.wikis.getCurrentWikiId());
    }

    @Override
    public String getDatabaseFromWikiName(String wikiId) {
        if (wikiId == null) {
            return null;
        }
        Object database = wikiId;
        String mainWikiId = this.wikis.getMainWikiId();
        if (StringUtils.equalsIgnoreCase((CharSequence)wikiId, (CharSequence)mainWikiId) && (database = this.hibernateConfiguration.getDB()) == null) {
            database = this.getDefaultMainWikiDatabase(mainWikiId);
        }
        String prefix = this.hibernateConfiguration.getDBPrefix();
        database = prefix + (String)database;
        database = this.cleanDatabaseName((String)database);
        return database;
    }

    protected String getDefaultMainWikiDatabase(String wikiId) {
        return wikiId;
    }

    protected String cleanDatabaseName(String name) {
        String cleanName = name.replace('-', '_');
        return cleanName;
    }

    @Override
    public String getTableName(PersistentClass persistentClass) {
        return this.getTableName(persistentClass.getTable());
    }

    @Override
    public String getTableName(Table table) {
        return this.getTableName(table.getName());
    }

    @Override
    public String getTableName(String tableName) {
        return tableName;
    }

    @Override
    public boolean isCompressed(PersistentClass entity) {
        return entity.getMetaAttribute("xwiki-compressed") != null;
    }

    @Override
    public String escapeDatabaseName(String databaseName) {
        String closeQuote = String.valueOf(this.getDialect().closeQuote());
        return this.getDialect().openQuote() + databaseName.replace(closeQuote, closeQuote + closeQuote) + closeQuote;
    }

    protected Optional<Boolean> getCompressionAllowedConfiguration() {
        String configuration = this.hibernateStore.getConfiguration().getProperty("xwiki.compressionAllowed");
        if (configuration == null) {
            return Optional.empty();
        }
        return Optional.of(Boolean.valueOf(configuration));
    }

    @Override
    public boolean isCompressionAllowed() {
        return this.getCompressionAllowedConfiguration().orElse(false);
    }

    @Override
    public SessionFactory getSessionFactory() {
        return this.hibernateStore.getSessionFactory();
    }

    @Override
    public Dialect getDialect() {
        return this.hibernateStore.getDialect();
    }

    @Override
    public void updateDatabase(Metadata metadata) throws HibernateStoreException {
        try {
            SessionFactory sessionFactory = this.getSessionFactory();
            try (Session session = sessionFactory.openSession();){
                this.updateDatabaseBegin(metadata, session);
            }
            this.updateDatabaseStandard(metadata);
            session = sessionFactory.openSession();
            try {
                this.updateDatabaseAfter(metadata, session);
            }
            finally {
                if (session != null) {
                    session.close();
                }
            }
        }
        catch (Exception e) {
            throw new HibernateException("Failed to update the database", (Throwable)e);
        }
    }

    private void updateDatabaseStandard(Metadata metadata) throws HibernateStoreException {
        SchemaUpdate updater = new SchemaUpdate();
        updater.execute(EnumSet.of(TargetType.DATABASE), metadata);
        List exceptions = updater.getExceptions();
        if (!exceptions.isEmpty()) {
            for (Exception exception : exceptions) {
                this.logger.error(exception.getMessage(), (Throwable)exception);
            }
            throw new HibernateStoreException("Failed to update the database. See the previous log for all errors", (Throwable)exceptions.get(0));
        }
    }

    protected void updateDatabaseBegin(Metadata metadata, Session session) throws HibernateStoreException {
    }

    protected void updateDatabaseAfter(Metadata metadata, Session session) throws HibernateStoreException {
    }

    @Override
    public boolean isCatalog() {
        return this.getDialect().canCreateCatalog();
    }
}

